/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;
import sun.security.krb5.internal.br;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class KerberosTime
implements Cloneable {
    private long kerberosTime;
    private static long syncTime;
    private static boolean DEBUG;
    public static final boolean NOW = true;
    public static final boolean UNADJUSTED_NOW = false;

    public static int getDefaultSkew() {
        int n2;
        block3: {
            n2 = 300;
            try {
                Config config = Config.getInstance();
                n2 = config.getDefaultIntValue("clockskew", "libdefaults");
                if (n2 == Integer.MIN_VALUE) {
                    n2 = 300;
                }
            }
            catch (KrbException krbException) {
                if (!DEBUG) break block3;
                System.out.println("Exception in getting clockskew from Configuration using default value " + krbException.getMessage());
            }
        }
        return n2;
    }

    public int getMicroSeconds() {
        Long l2 = new Long(this.kerberosTime % 1000L * 1000L);
        return l2.intValue();
    }

    public int getSeconds() {
        Long l2 = new Long(this.kerberosTime / 1000L);
        return l2.intValue();
    }

    public long getTime() {
        return this.kerberosTime;
    }

    static {
        DEBUG = br.ed;
    }

    public KerberosTime() {
        this.kerberosTime = 0L;
    }

    public void setNow() {
        Date date = new Date();
        this.setTime(date);
    }

    public boolean inClockSkew() {
        return this.inClockSkew(KerberosTime.getDefaultSkew());
    }

    public boolean isZero() {
        return this.kerberosTime == 0L;
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putGeneralizedTime(this.toDate());
        return derOutputStream.toByteArray();
    }

    public void setMicroSeconds(int n2) {
        Integer n3 = new Integer(n2);
        long l2 = n3.longValue() / 1000L;
        this.kerberosTime = this.kerberosTime - this.kerberosTime % 1000L + l2;
    }

    public void setSeconds(int n2) {
        Integer n3 = new Integer(n2);
        this.kerberosTime = n3.longValue() * 1000L;
    }

    public boolean inClockSkew(int n2) {
        KerberosTime kerberosTime = new KerberosTime(true);
        return Math.abs(this.kerberosTime - kerberosTime.kerberosTime) <= (long)n2 * 1000L;
    }

    public KerberosTime(long l2) {
        this.kerberosTime = l2;
    }

    public void setTime(long l2) {
        this.kerberosTime = l2;
    }

    public KerberosTime(boolean bl2) {
        if (bl2) {
            Date date = new Date();
            this.setTime(date);
        } else {
            this.kerberosTime = 0L;
        }
    }

    public void setMicroSeconds(Integer n2) {
        if (n2 != null) {
            long l2 = n2.longValue() / 1000L;
            this.kerberosTime = this.kerberosTime - this.kerberosTime % 1000L + l2;
        }
    }

    public Object clone() {
        return new KerberosTime(this.kerberosTime);
    }

    public String toGeneralizedTimeString() {
        Date date = new Date(this.kerberosTime);
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        date.setTime(date.getTime() - (long)(calendar.get(15) + calendar.get(16)));
        calendar.setTime(date);
        return KerberosTime.zeroPad(Integer.toString(calendar.get(1)), 4) + KerberosTime.zeroPad(Integer.toString(calendar.get(2) + 1), 2) + KerberosTime.zeroPad(Integer.toString(calendar.get(5)), 2) + KerberosTime.zeroPad(Integer.toString(calendar.get(11)), 2) + KerberosTime.zeroPad(Integer.toString(calendar.get(12)), 2) + KerberosTime.zeroPad(Integer.toString(calendar.get(13)), 2) + 'Z';
    }

    public String toString() {
        return this.toGeneralizedTimeString();
    }

    private static long toKerberosTime(String string) throws Asn1Exception {
        if (string.length() != 15) {
            throw new Asn1Exception(900);
        }
        if (string.charAt(14) != 'Z') {
            throw new Asn1Exception(900);
        }
        int n2 = Integer.parseInt(string.substring(0, 4));
        Calendar calendar = Calendar.getInstance();
        calendar.set(n2, Integer.parseInt(string.substring(4, 6)) - 1, Integer.parseInt(string.substring(6, 8)), Integer.parseInt(string.substring(8, 10)), Integer.parseInt(string.substring(10, 12)), Integer.parseInt(string.substring(12, 14)));
        return calendar.getTime().getTime();
    }

    public KerberosTime(String string) throws Asn1Exception {
        this.kerberosTime = KerberosTime.toKerberosTime(string);
    }

    public Date toDate() {
        Date date = new Date(this.kerberosTime);
        date.setTime(date.getTime());
        return date;
    }

    public KerberosTime(Date date) {
        this.kerberosTime = date.getTime();
    }

    public void setTime(Date date) {
        this.kerberosTime = date.getTime();
    }

    public boolean inClockSkew(int n2, KerberosTime kerberosTime) {
        return Math.abs(this.kerberosTime - kerberosTime.kerberosTime) <= (long)n2 * 1000L;
    }

    public boolean equals(KerberosTime kerberosTime) {
        return this.kerberosTime == kerberosTime.kerberosTime;
    }

    public boolean greaterThan(KerberosTime kerberosTime) {
        return this.kerberosTime > kerberosTime.kerberosTime;
    }

    public boolean greaterThanWRTClockSkew(KerberosTime kerberosTime) {
        return this.greaterThanWRTClockSkew(kerberosTime, KerberosTime.getDefaultSkew());
    }

    public boolean inClockSkew(KerberosTime kerberosTime) {
        return this.inClockSkew(KerberosTime.getDefaultSkew(), kerberosTime);
    }

    public boolean greaterThanWRTClockSkew(KerberosTime kerberosTime, int n2) {
        return this.kerberosTime - kerberosTime.kerberosTime > (long)n2 * 1000L;
    }

    public KerberosTime(DerValue derValue) throws Asn1Exception, IOException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Date date = derValue.getGeneralizedTime();
        this.kerberosTime = date.getTime();
    }

    public static String zeroPad(String string, int n2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.length() < n2) {
            stringBuffer.insert(0, '0');
        }
        return stringBuffer.toString();
    }

    public static KerberosTime parse(DerInputStream derInputStream, byte by, boolean bl2) throws Asn1Exception, IOException {
        if (bl2 && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new KerberosTime(derValue2);
    }
}

