/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.basic.BasicTransferable;
import javax.swing.text.JTextComponent;

public class BasicFileChooserUI
extends FileChooserUI {
    protected Icon directoryIcon = null;
    protected Icon fileIcon = null;
    protected Icon computerIcon = null;
    protected Icon hardDriveIcon = null;
    protected Icon floppyDriveIcon = null;
    protected Icon newFolderIcon = null;
    protected Icon upFolderIcon = null;
    protected Icon homeFolderIcon = null;
    protected Icon listViewIcon = null;
    protected Icon detailsViewIcon = null;
    protected int saveButtonMnemonic = 0;
    protected int openButtonMnemonic = 0;
    protected int cancelButtonMnemonic = 0;
    protected int updateButtonMnemonic = 0;
    protected int helpButtonMnemonic = 0;
    protected int directoryOpenButtonMnemonic = 0;
    protected String saveButtonText = null;
    protected String openButtonText = null;
    protected String cancelButtonText = null;
    protected String updateButtonText = null;
    protected String helpButtonText = null;
    protected String directoryOpenButtonText = null;
    private String openDialogTitleText = null;
    private String saveDialogTitleText = null;
    protected String saveButtonToolTipText = null;
    protected String openButtonToolTipText = null;
    protected String cancelButtonToolTipText = null;
    protected String updateButtonToolTipText = null;
    protected String helpButtonToolTipText = null;
    protected String directoryOpenButtonToolTipText = null;
    private Action approveSelectionAction = new ApproveSelectionAction(this);
    private Action cancelSelectionAction = new CancelSelectionAction(this);
    private Action updateAction = new UpdateAction(this);
    private Action newFolderAction = new NewFolderAction(this);
    private Action goHomeAction = new GoHomeAction(this);
    private Action changeToParentDirectoryAction = new ChangeToParentDirectoryAction(this);
    private String newFolderErrorSeparator = null;
    private String newFolderErrorText = null;
    private String fileDescriptionText = null;
    private String directoryDescriptionText = null;
    private JFileChooser filechooser = null;
    private boolean directorySelected = false;
    private File directory = null;
    private PropertyChangeListener propertyChangeListener = null;
    private AcceptAllFileFilter acceptAllFileFilter = new AcceptAllFileFilter(this);
    private FileFilter actualFileFilter = null;
    private GlobFilter globFilter = null;
    private BasicDirectoryModel model = null;
    private BasicFileView fileView = new BasicFileView(this);
    private JPanel accessoryPanel = null;
    private static final TransferHandler defaultTransferHandler = new FileTransferHandler();

    public void clearIconCache() {
        this.fileView.clearIconCache();
    }

    protected void createModel() {
        if (this.model != null) {
            this.model.invalidateFileCache();
        }
        this.model = new BasicDirectoryModel(this.getFileChooser());
    }

    private void resetGlobFilter() {
        if (this.actualFileFilter != null) {
            JFileChooser jFileChooser = this.getFileChooser();
            FileFilter fileFilter = jFileChooser.getFileFilter();
            if (fileFilter != null && fileFilter.equals(this.globFilter)) {
                jFileChooser.setFileFilter(this.actualFileFilter);
                jFileChooser.removeChoosableFileFilter(this.globFilter);
            }
            this.actualFileFilter = null;
        }
    }

    protected boolean isDirectorySelected() {
        return this.directorySelected;
    }

    protected void setDirectorySelected(boolean bl2) {
        this.directorySelected = bl2;
    }

    protected File getDirectory() {
        return this.directory;
    }

    protected void setDirectory(File file) {
        this.directory = file;
    }

    public String getDirectoryName() {
        return null;
    }

    public String getFileName() {
        return null;
    }

    public void setDirectoryName(String string) {
    }

    public void setFileName(String string) {
    }

    static boolean access$400(String string) {
        return BasicFileChooserUI.isGlobPattern(string);
    }

    private static boolean isGlobPattern(String string) {
        return File.separatorChar == '\\' && string.indexOf(42) >= 0 || File.separatorChar == '/' && (string.indexOf(42) >= 0 || string.indexOf(63) >= 0 || string.indexOf(91) >= 0);
    }

    public Action getApproveSelectionAction() {
        return this.approveSelectionAction;
    }

    public Action getCancelSelectionAction() {
        return this.cancelSelectionAction;
    }

    public Action getChangeToParentDirectoryAction() {
        return this.changeToParentDirectoryAction;
    }

    public Action getGoHomeAction() {
        return this.goHomeAction;
    }

    public Action getNewFolderAction() {
        return this.newFolderAction;
    }

    public Action getUpdateAction() {
        return this.updateAction;
    }

    ActionMap createActionMap() {
        AbstractAction abstractAction = new AbstractAction(this){
            private final BasicFileChooserUI this$0;

            public boolean isEnabled() {
                return this.this$0.getFileChooser().isEnabled();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.getFileChooser().cancelSelection();
            }
            {
                this.this$0 = basicFileChooserUI;
            }
        };
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("approveSelection", this.getApproveSelectionAction());
        actionMapUIResource.put("cancelSelection", abstractAction);
        actionMapUIResource.put("Go Up", this.getChangeToParentDirectoryAction());
        return actionMapUIResource;
    }

    ActionMap getActionMap() {
        return this.createActionMap();
    }

    InputMap getInputMap(int n2) {
        if (n2 == 1) {
            return (InputMap)UIManager.get("FileChooser.ancestorInputMap");
        }
        return null;
    }

    public void installUI(JComponent jComponent) {
        this.accessoryPanel = new JPanel(new BorderLayout());
        this.filechooser = (JFileChooser)jComponent;
        this.createModel();
        this.clearIconCache();
        this.installDefaults(this.filechooser);
        this.installComponents(this.filechooser);
        this.installListeners(this.filechooser);
        this.filechooser.applyComponentOrientation(this.filechooser.getComponentOrientation());
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners(this.filechooser);
        this.uninstallComponents(this.filechooser);
        this.uninstallDefaults(this.filechooser);
        if (this.accessoryPanel != null) {
            this.accessoryPanel.removeAll();
        }
        this.accessoryPanel = null;
        this.getFileChooser().removeAll();
    }

    public JFileChooser getFileChooser() {
        return this.filechooser;
    }

    public int getApproveButtonMnemonic(JFileChooser jFileChooser) {
        int n2 = jFileChooser.getApproveButtonMnemonic();
        if (n2 > 0) {
            return n2;
        }
        if (jFileChooser.getDialogType() == 0) {
            return this.openButtonMnemonic;
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveButtonMnemonic;
        }
        return n2;
    }

    public BasicFileChooserUI(JFileChooser jFileChooser) {
    }

    public void installComponents(JFileChooser jFileChooser) {
    }

    protected void installDefaults(JFileChooser jFileChooser) {
        this.installIcons(jFileChooser);
        this.installStrings(jFileChooser);
        TransferHandler transferHandler = jFileChooser.getTransferHandler();
        if (transferHandler == null || transferHandler instanceof UIResource) {
            jFileChooser.setTransferHandler(defaultTransferHandler);
        }
    }

    protected void installIcons(JFileChooser jFileChooser) {
        this.directoryIcon = UIManager.getIcon("FileView.directoryIcon");
        this.fileIcon = UIManager.getIcon("FileView.fileIcon");
        this.computerIcon = UIManager.getIcon("FileView.computerIcon");
        this.hardDriveIcon = UIManager.getIcon("FileView.hardDriveIcon");
        this.floppyDriveIcon = UIManager.getIcon("FileView.floppyDriveIcon");
        this.newFolderIcon = UIManager.getIcon("FileChooser.newFolderIcon");
        this.upFolderIcon = UIManager.getIcon("FileChooser.upFolderIcon");
        this.homeFolderIcon = UIManager.getIcon("FileChooser.homeFolderIcon");
        this.detailsViewIcon = UIManager.getIcon("FileChooser.detailsViewIcon");
        this.listViewIcon = UIManager.getIcon("FileChooser.listViewIcon");
    }

    protected void installListeners(JFileChooser jFileChooser) {
        this.propertyChangeListener = this.createPropertyChangeListener(jFileChooser);
        if (this.propertyChangeListener != null) {
            jFileChooser.addPropertyChangeListener(this.propertyChangeListener);
        }
        jFileChooser.addPropertyChangeListener(this.getModel());
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(jFileChooser, 1, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(jFileChooser, actionMap);
    }

    protected void installStrings(JFileChooser jFileChooser) {
        Locale locale = jFileChooser.getLocale();
        this.newFolderErrorText = UIManager.getString((Object)"FileChooser.newFolderErrorText", locale);
        this.newFolderErrorSeparator = UIManager.getString((Object)"FileChooser.newFolderErrorSeparator", locale);
        this.fileDescriptionText = UIManager.getString((Object)"FileChooser.fileDescriptionText", locale);
        this.directoryDescriptionText = UIManager.getString((Object)"FileChooser.directoryDescriptionText", locale);
        this.saveButtonText = UIManager.getString((Object)"FileChooser.saveButtonText", locale);
        this.openButtonText = UIManager.getString((Object)"FileChooser.openButtonText", locale);
        this.saveDialogTitleText = UIManager.getString((Object)"FileChooser.saveDialogTitleText", locale);
        this.openDialogTitleText = UIManager.getString((Object)"FileChooser.openDialogTitleText", locale);
        this.cancelButtonText = UIManager.getString((Object)"FileChooser.cancelButtonText", locale);
        this.updateButtonText = UIManager.getString((Object)"FileChooser.updateButtonText", locale);
        this.helpButtonText = UIManager.getString((Object)"FileChooser.helpButtonText", locale);
        this.directoryOpenButtonText = UIManager.getString((Object)"FileChooser.directoryOpenButtonText", locale);
        this.saveButtonMnemonic = UIManager.getInt("FileChooser.saveButtonMnemonic");
        this.openButtonMnemonic = UIManager.getInt("FileChooser.openButtonMnemonic");
        this.cancelButtonMnemonic = UIManager.getInt("FileChooser.cancelButtonMnemonic");
        this.updateButtonMnemonic = UIManager.getInt("FileChooser.updateButtonMnemonic");
        this.helpButtonMnemonic = UIManager.getInt("FileChooser.helpButtonMnemonic");
        this.directoryOpenButtonMnemonic = UIManager.getInt("FileChooser.directoryOpenButtonMnemonic");
        this.saveButtonToolTipText = UIManager.getString((Object)"FileChooser.saveButtonToolTipText", locale);
        this.openButtonToolTipText = UIManager.getString((Object)"FileChooser.openButtonToolTipText", locale);
        this.cancelButtonToolTipText = UIManager.getString((Object)"FileChooser.cancelButtonToolTipText", locale);
        this.updateButtonToolTipText = UIManager.getString((Object)"FileChooser.updateButtonToolTipText", locale);
        this.helpButtonToolTipText = UIManager.getString((Object)"FileChooser.helpButtonToolTipText", locale);
        this.directoryOpenButtonToolTipText = UIManager.getString((Object)"FileChooser.directoryOpenButtonToolTipText", locale);
    }

    public void rescanCurrentDirectory(JFileChooser jFileChooser) {
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
    }

    protected void uninstallDefaults(JFileChooser jFileChooser) {
        this.uninstallIcons(jFileChooser);
        this.uninstallStrings(jFileChooser);
        if (jFileChooser.getTransferHandler() instanceof UIResource) {
            jFileChooser.setTransferHandler(null);
        }
    }

    protected void uninstallIcons(JFileChooser jFileChooser) {
        this.directoryIcon = null;
        this.fileIcon = null;
        this.computerIcon = null;
        this.hardDriveIcon = null;
        this.floppyDriveIcon = null;
        this.newFolderIcon = null;
        this.upFolderIcon = null;
        this.homeFolderIcon = null;
        this.detailsViewIcon = null;
        this.listViewIcon = null;
    }

    protected void uninstallListeners(JFileChooser jFileChooser) {
        if (this.propertyChangeListener != null) {
            jFileChooser.removePropertyChangeListener(this.propertyChangeListener);
        }
        jFileChooser.removePropertyChangeListener(this.getModel());
        SwingUtilities.replaceUIInputMap(jFileChooser, 1, null);
        SwingUtilities.replaceUIActionMap(jFileChooser, null);
    }

    protected void uninstallStrings(JFileChooser jFileChooser) {
        this.saveButtonText = null;
        this.openButtonText = null;
        this.cancelButtonText = null;
        this.updateButtonText = null;
        this.helpButtonText = null;
        this.directoryOpenButtonText = null;
        this.saveButtonToolTipText = null;
        this.openButtonToolTipText = null;
        this.cancelButtonToolTipText = null;
        this.updateButtonToolTipText = null;
        this.helpButtonToolTipText = null;
        this.directoryOpenButtonToolTipText = null;
    }

    public JPanel getAccessoryPanel() {
        return this.accessoryPanel;
    }

    public BasicDirectoryModel getModel() {
        return this.model;
    }

    static void access$300(BasicFileChooserUI basicFileChooserUI) {
        basicFileChooserUI.resetGlobFilter();
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return null;
    }

    public void ensureFileIsVisible(JFileChooser jFileChooser, File file) {
    }

    public String getApproveButtonText(JFileChooser jFileChooser) {
        String string = jFileChooser.getApproveButtonText();
        if (string != null) {
            return string;
        }
        if (jFileChooser.getDialogType() == 0) {
            return this.openButtonText;
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveButtonText;
        }
        return null;
    }

    public String getApproveButtonToolTipText(JFileChooser jFileChooser) {
        String string = jFileChooser.getApproveButtonToolTipText();
        if (string != null) {
            return string;
        }
        if (jFileChooser.getDialogType() == 0) {
            return this.openButtonToolTipText;
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveButtonToolTipText;
        }
        return null;
    }

    public String getDialogTitle(JFileChooser jFileChooser) {
        String string = jFileChooser.getDialogTitle();
        if (string != null) {
            return string;
        }
        if (jFileChooser.getDialogType() == 0) {
            return this.openDialogTitleText;
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveDialogTitleText;
        }
        return this.getApproveButtonText(jFileChooser);
    }

    static String access$100(BasicFileChooserUI basicFileChooserUI) {
        return basicFileChooserUI.newFolderErrorText;
    }

    static String access$200(BasicFileChooserUI basicFileChooserUI) {
        return basicFileChooserUI.newFolderErrorSeparator;
    }

    static String access$700(BasicFileChooserUI basicFileChooserUI) {
        return basicFileChooserUI.directoryDescriptionText;
    }

    static String access$800(BasicFileChooserUI basicFileChooserUI) {
        return basicFileChooserUI.fileDescriptionText;
    }

    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return null;
    }

    static JFileChooser access$000(BasicFileChooserUI basicFileChooserUI) {
        return basicFileChooserUI.filechooser;
    }

    public ListSelectionListener createListSelectionListener(JFileChooser jFileChooser) {
        return new SelectionListener(this);
    }

    public FileFilter getAcceptAllFileFilter(JFileChooser jFileChooser) {
        return this.acceptAllFileFilter;
    }

    public FileView getFileView(JFileChooser jFileChooser) {
        return this.fileView;
    }

    static GlobFilter access$500(BasicFileChooserUI basicFileChooserUI) {
        return basicFileChooserUI.globFilter;
    }

    protected MouseListener createDoubleClickListener(JFileChooser jFileChooser, JList jList) {
        return new DoubleClickListener(this, jList);
    }

    static FileFilter access$602(BasicFileChooserUI basicFileChooserUI, FileFilter fileFilter) {
        basicFileChooserUI.actualFileFilter = fileFilter;
        return basicFileChooserUI.actualFileFilter;
    }

    static GlobFilter access$502(BasicFileChooserUI basicFileChooserUI, GlobFilter globFilter) {
        basicFileChooserUI.globFilter = globFilter;
        return basicFileChooserUI.globFilter;
    }

    protected class AcceptAllFileFilter
    extends FileFilter {
        private final BasicFileChooserUI this$0;

        public boolean accept(File file) {
            return true;
        }

        public String getDescription() {
            return UIManager.getString((Object)"FileChooser.acceptAllFileFilterText", this.this$0.getFileChooser().getLocale());
        }

        public AcceptAllFileFilter(BasicFileChooserUI basicFileChooserUI) {
            this.this$0 = basicFileChooserUI;
        }
    }

    protected class ApproveSelectionAction
    extends AbstractAction {
        private final BasicFileChooserUI this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            Serializable serializable;
            if (this.this$0.isDirectorySelected() && (serializable = this.this$0.getDirectory()) != null) {
                try {
                    serializable = ((File)serializable).getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.this$0.getFileChooser().setCurrentDirectory((File)serializable);
                return;
            }
            serializable = this.this$0.getFileChooser();
            String string = this.this$0.getFileName();
            FileSystemView fileSystemView = ((JFileChooser)serializable).getFileSystemView();
            File file = ((JFileChooser)serializable).getCurrentDirectory();
            if (string != null) {
                string = string.trim();
            }
            if (string == null || string.equals("")) {
                BasicFileChooserUI.access$300(this.this$0);
                return;
            }
            File file2 = null;
            File[] fileArray = null;
            if (string != null && !string.equals("")) {
                if (File.separatorChar == '/') {
                    if (string.startsWith("~/")) {
                        string = System.getProperty("user.home") + string.substring(1);
                    } else if (string.equals("~")) {
                        string = System.getProperty("user.home");
                    }
                }
                if (((JFileChooser)serializable).isMultiSelectionEnabled() && string.startsWith("\"")) {
                    ArrayList arrayList = new ArrayList();
                    if ((string = string.substring(1)).endsWith("\"")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    Object[] objectArray = null;
                    int n2 = 0;
                    do {
                        String string2;
                        int n3;
                        if ((n3 = string.indexOf("\" \"")) > 0) {
                            string2 = string.substring(0, n3);
                            string = string.substring(n3 + 3);
                        } else {
                            string2 = string;
                            string = "";
                        }
                        Object object = fileSystemView.createFileObject(string2);
                        if (!((File)object).isAbsolute()) {
                            if (objectArray == null) {
                                objectArray = fileSystemView.getFiles(file, false);
                                Arrays.sort(objectArray);
                            }
                            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                                int n4 = (n2 + i2) % objectArray.length;
                                if (!((File)objectArray[n4]).getName().equals(string2)) continue;
                                object = objectArray[n4];
                                n2 = n4 + 1;
                                break;
                            }
                        }
                        arrayList.add(object);
                    } while (string.length() > 0);
                    if (arrayList.size() > 0) {
                        fileArray = (File[])arrayList.toArray(new File[arrayList.size()]);
                    }
                    BasicFileChooserUI.access$300(this.this$0);
                } else {
                    file2 = fileSystemView.createFileObject(string);
                    if (!file2.isAbsolute()) {
                        file2 = fileSystemView.getChild(file, string);
                    }
                    FileFilter fileFilter = ((JFileChooser)serializable).getFileFilter();
                    if (!file2.exists() && BasicFileChooserUI.access$400(string)) {
                        if (BasicFileChooserUI.access$500(this.this$0) == null) {
                            BasicFileChooserUI.access$502(this.this$0, new GlobFilter(this.this$0));
                        }
                        try {
                            BasicFileChooserUI.access$500(this.this$0).setPattern(string);
                            if (!(fileFilter instanceof GlobFilter)) {
                                BasicFileChooserUI.access$602(this.this$0, fileFilter);
                            }
                            ((JFileChooser)serializable).setFileFilter(null);
                            ((JFileChooser)serializable).setFileFilter(BasicFileChooserUI.access$500(this.this$0));
                            return;
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                            // empty catch block
                        }
                    }
                    BasicFileChooserUI.access$300(this.this$0);
                    boolean bl2 = file2 != null && file2.isDirectory();
                    boolean bl3 = file2 != null && ((JFileChooser)serializable).isTraversable(file2);
                    boolean bl4 = ((JFileChooser)serializable).isDirectorySelectionEnabled();
                    boolean bl5 = ((JFileChooser)serializable).isFileSelectionEnabled();
                    if (bl2 && bl3 && !bl4) {
                        ((JFileChooser)serializable).setCurrentDirectory(file2);
                        return;
                    }
                    if (!(!bl2 && bl5 || bl2 && bl4 || bl4 && !file2.exists())) {
                        file2 = null;
                    }
                }
            }
            if (fileArray != null || file2 != null) {
                if (fileArray != null || ((JFileChooser)serializable).isMultiSelectionEnabled()) {
                    if (fileArray == null) {
                        fileArray = new File[]{file2};
                    }
                    ((JFileChooser)serializable).setSelectedFiles(fileArray);
                    ((JFileChooser)serializable).setSelectedFiles(fileArray);
                } else {
                    ((JFileChooser)serializable).setSelectedFile(file2);
                }
                ((JFileChooser)serializable).approveSelection();
            } else {
                if (((JFileChooser)serializable).isMultiSelectionEnabled()) {
                    ((JFileChooser)serializable).setSelectedFiles(null);
                } else {
                    ((JFileChooser)serializable).setSelectedFile(null);
                }
                ((JFileChooser)serializable).cancelSelection();
            }
        }

        protected ApproveSelectionAction(BasicFileChooserUI basicFileChooserUI) {
            this.this$0 = basicFileChooserUI;
            super("approveSelection");
        }
    }

    protected class BasicFileView
    extends FileView {
        protected Hashtable iconCache;
        private final BasicFileChooserUI this$0;

        public void clearIconCache() {
            this.iconCache = new Hashtable();
        }

        public BasicFileView(BasicFileChooserUI basicFileChooserUI) {
            this.this$0 = basicFileChooserUI;
            this.iconCache = new Hashtable();
        }

        public Boolean isHidden(File file) {
            String string = file.getName();
            if (string != null && string.charAt(0) == '.') {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public String getDescription(File file) {
            return file.getName();
        }

        public String getName(File file) {
            String string = null;
            if (file != null) {
                string = this.this$0.getFileChooser().getFileSystemView().getSystemDisplayName(file);
            }
            return string;
        }

        public String getTypeDescription(File file) {
            String string = this.this$0.getFileChooser().getFileSystemView().getSystemTypeDescription(file);
            if (string == null) {
                string = file.isDirectory() ? BasicFileChooserUI.access$700(this.this$0) : BasicFileChooserUI.access$800(this.this$0);
            }
            return string;
        }

        public Icon getCachedIcon(File file) {
            return (Icon)this.iconCache.get(file);
        }

        public Icon getIcon(File file) {
            Icon icon = this.getCachedIcon(file);
            if (icon != null) {
                return icon;
            }
            icon = this.this$0.fileIcon;
            if (file != null) {
                FileSystemView fileSystemView = this.this$0.getFileChooser().getFileSystemView();
                if (fileSystemView.isFloppyDrive(file)) {
                    icon = this.this$0.floppyDriveIcon;
                } else if (fileSystemView.isDrive(file)) {
                    icon = this.this$0.hardDriveIcon;
                } else if (fileSystemView.isComputerNode(file)) {
                    icon = this.this$0.computerIcon;
                } else if (file.isDirectory()) {
                    icon = this.this$0.directoryIcon;
                }
            }
            this.cacheIcon(file, icon);
            return icon;
        }

        public void cacheIcon(File file, Icon icon) {
            if (file == null || icon == null) {
                return;
            }
            this.iconCache.put(file, icon);
        }
    }

    protected class CancelSelectionAction
    extends AbstractAction {
        private final BasicFileChooserUI this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            this.this$0.getFileChooser().cancelSelection();
        }

        protected CancelSelectionAction(BasicFileChooserUI basicFileChooserUI) {
            this.this$0 = basicFileChooserUI;
        }
    }

    protected class ChangeToParentDirectoryAction
    extends AbstractAction {
        private final BasicFileChooserUI this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (component == null || !(component instanceof JTextComponent)) {
                this.this$0.getFileChooser().changeToParentDirectory();
            }
        }

        protected ChangeToParentDirectoryAction(BasicFileChooserUI basicFileChooserUI) {
            this.this$0 = basicFileChooserUI;
            super("Go Up");
        }
    }

    protected class DoubleClickListener
    extends MouseAdapter {
        JList list;
        private final BasicFileChooserUI this$0;

        public void mouseClicked(MouseEvent mouseEvent) {
            int n2;
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && (n2 = this.list.locationToIndex(mouseEvent.getPoint())) >= 0) {
                File file = (File)this.list.getModel().getElementAt(n2);
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this.this$0.getFileChooser().isTraversable(file)) {
                    this.list.clearSelection();
                    this.this$0.getFileChooser().setCurrentDirectory(file);
                    if (this.this$0.getFileChooser().getFileSelectionMode() == 2 && this.this$0.getFileChooser().getFileSystemView().isFileSystem(file)) {
                        this.this$0.setFileName(file.toString());
                    }
                } else {
                    this.this$0.getFileChooser().approveSelection();
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            TransferHandler transferHandler;
            TransferHandler transferHandler2 = BasicFileChooserUI.access$000(this.this$0).getTransferHandler();
            if (transferHandler2 != (transferHandler = this.list.getTransferHandler())) {
                this.list.setTransferHandler(transferHandler2);
            }
            if (BasicFileChooserUI.access$000(this.this$0).getDragEnabled() != this.list.getDragEnabled()) {
                this.list.setDragEnabled(BasicFileChooserUI.access$000(this.this$0).getDragEnabled());
            }
        }

        public DoubleClickListener(BasicFileChooserUI basicFileChooserUI, JList jList) {
            this.this$0 = basicFileChooserUI;
            this.list = jList;
        }
    }

    static class FileTransferHandler
    extends TransferHandler
    implements UIResource {
        FileTransferHandler() {
        }

        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        protected Transferable createTransferable(JComponent jComponent) {
            int n2;
            Serializable serializable;
            Object object;
            Object[] objectArray = null;
            if (jComponent instanceof JList) {
                objectArray = ((JList)jComponent).getSelectedValues();
            } else if (jComponent instanceof JTable && (object = ((JTable)(serializable = (JTable)jComponent)).getSelectedRows()) != null) {
                objectArray = new Object[((int[])object).length];
                for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                    objectArray[n2] = ((JTable)serializable).getValueAt((int)object[n2], 0);
                }
            }
            if (objectArray == null || objectArray.length == 0) {
                return null;
            }
            serializable = new StringBuffer();
            object = new StringBuffer();
            ((StringBuffer)object).append("<html>\n<body>\n<ul>\n");
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                Object object2 = objectArray[n2];
                String string = object2 == null ? "" : object2.toString();
                ((StringBuffer)serializable).append(string + "\n");
                ((StringBuffer)object).append("  <li>" + string + "\n");
            }
            ((StringBuffer)serializable).deleteCharAt(((StringBuffer)serializable).length() - 1);
            ((StringBuffer)object).append("</ul>\n</body>\n</html>");
            return new FileTransferable(((StringBuffer)serializable).toString(), ((StringBuffer)object).toString(), objectArray);
        }

        static class FileTransferable
        extends BasicTransferable {
            Object[] fileData;

            protected DataFlavor[] getRicherFlavors() {
                DataFlavor[] dataFlavorArray = new DataFlavor[]{DataFlavor.javaFileListFlavor};
                return dataFlavorArray;
            }

            protected Object getRicherData(DataFlavor dataFlavor) {
                if (DataFlavor.javaFileListFlavor.equals(dataFlavor)) {
                    ArrayList arrayList = new ArrayList();
                    for (int i2 = 0; i2 < this.fileData.length; ++i2) {
                        arrayList.add(this.fileData[i2]);
                    }
                    return arrayList;
                }
                return null;
            }

            FileTransferable(String string, String string2, Object[] objectArray) {
                super(string, string2);
                this.fileData = objectArray;
            }
        }
    }

    class GlobFilter
    extends FileFilter {
        Pattern pattern;
        String globPattern;
        private final BasicFileChooserUI this$0;

        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            return this.pattern.matcher(file.getName()).matches();
        }

        public String getDescription() {
            return this.globPattern;
        }

        public void setPattern(String string) {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length * 2];
            boolean bl2 = File.separatorChar == '\\';
            boolean bl3 = false;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            this.globPattern = string;
            if (bl2) {
                int n3 = cArray.length;
                if (string.endsWith("*.*")) {
                    n3 -= 2;
                }
                block15: for (int i2 = 0; i2 < n3; ++i2) {
                    switch (cArray[i2]) {
                        case '*': {
                            cArray2[n2++] = 46;
                            cArray2[n2++] = 42;
                            continue block15;
                        }
                        case '\\': {
                            cArray2[n2++] = 92;
                            cArray2[n2++] = 92;
                            continue block15;
                        }
                        default: {
                            if ("+()^$.{}[]".indexOf(cArray[i2]) >= 0) {
                                cArray2[n2++] = 92;
                            }
                            cArray2[n2++] = cArray[i2];
                        }
                    }
                }
            } else {
                block16: for (int i3 = 0; i3 < cArray.length; ++i3) {
                    switch (cArray[i3]) {
                        case '*': {
                            if (!bl3) {
                                cArray2[n2++] = 46;
                            }
                            cArray2[n2++] = 42;
                            continue block16;
                        }
                        case '?': {
                            cArray2[n2++] = bl3 ? 63 : 46;
                            continue block16;
                        }
                        case '[': {
                            bl3 = true;
                            cArray2[n2++] = cArray[i3];
                            if (i3 >= cArray.length - 1) continue block16;
                            switch (cArray[i3 + 1]) {
                                case '!': 
                                case '^': {
                                    cArray2[n2++] = 94;
                                    ++i3;
                                    break;
                                }
                                case ']': {
                                    cArray2[n2++] = cArray[++i3];
                                }
                            }
                            continue block16;
                        }
                        case ']': {
                            cArray2[n2++] = cArray[i3];
                            bl3 = false;
                            continue block16;
                        }
                        case '\\': {
                            if (i3 == 0 && cArray.length > 1 && cArray[1] == '~') {
                                cArray2[n2++] = cArray[++i3];
                                continue block16;
                            }
                            cArray2[n2++] = 92;
                            if (i3 < cArray.length - 1 && "*?[]".indexOf(cArray[i3 + 1]) >= 0) {
                                cArray2[n2++] = cArray[++i3];
                                continue block16;
                            }
                            cArray2[n2++] = 92;
                            continue block16;
                        }
                        default: {
                            if (!Character.isLetterOrDigit(cArray[i3])) {
                                cArray2[n2++] = 92;
                            }
                            cArray2[n2++] = cArray[i3];
                        }
                    }
                }
            }
            this.pattern = Pattern.compile(new String(cArray2, 0, n2), 2);
        }

        GlobFilter(BasicFileChooserUI basicFileChooserUI) {
            this.this$0 = basicFileChooserUI;
        }
    }

    protected class GoHomeAction
    extends AbstractAction {
        private final BasicFileChooserUI this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = this.this$0.getFileChooser();
            jFileChooser.setCurrentDirectory(jFileChooser.getFileSystemView().getHomeDirectory());
        }

        protected GoHomeAction(BasicFileChooserUI basicFileChooserUI) {
            this.this$0 = basicFileChooserUI;
            super("Go Home");
        }
    }

    protected class NewFolderAction
    extends AbstractAction {
        private final BasicFileChooserUI this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = this.this$0.getFileChooser();
            File file = jFileChooser.getCurrentDirectory();
            File file2 = null;
            try {
                file2 = jFileChooser.getFileSystemView().createNewFolder(file);
                if (jFileChooser.isMultiSelectionEnabled()) {
                    jFileChooser.setSelectedFiles(new File[]{file2});
                } else {
                    jFileChooser.setSelectedFile(file2);
                }
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(jFileChooser, BasicFileChooserUI.access$100(this.this$0) + BasicFileChooserUI.access$200(this.this$0) + iOException, BasicFileChooserUI.access$100(this.this$0), 0);
                return;
            }
            jFileChooser.rescanCurrentDirectory();
        }

        protected NewFolderAction(BasicFileChooserUI basicFileChooserUI) {
            this.this$0 = basicFileChooserUI;
            super("New Folder");
        }
    }

    protected class SelectionListener
    implements ListSelectionListener {
        private final BasicFileChooserUI this$0;

        /*
         * Unable to fully structure code
         */
        public void valueChanged(ListSelectionEvent var1_1) {
            block7: {
                block8: {
                    block9: {
                        if (var1_1.getValueIsAdjusting()) break block7;
                        var2_2 = this.this$0.getFileChooser();
                        var3_3 = (JList)var1_1.getSource();
                        if (!var2_2.isMultiSelectionEnabled()) break block8;
                        var4_4 = null;
                        var5_6 = var3_3.getSelectedValues();
                        if (var5_6 == null) break block9;
                        if (var5_6.length != 1 || !((File)var5_6[0]).isDirectory() || !var2_2.isTraversable((File)var5_6[0])) ** GOTO lbl-1000
                        if (var2_2.getFileSelectionMode() != 1 || !var2_2.getFileSystemView().isFileSystem((File)var5_6[0])) {
                            this.this$0.setDirectorySelected(true);
                            this.this$0.setDirectory((File)var5_6[0]);
                        } else lbl-1000:
                        // 2 sources

                        {
                            var6_7 = new ArrayList(var5_6.length);
                            for (var7_8 = 0; var7_8 < var5_6.length; ++var7_8) {
                                var8_9 = (File)var5_6[var7_8];
                                if ((!var2_2.isFileSelectionEnabled() || !var8_9.isFile()) && (!var2_2.isDirectorySelectionEnabled() || !var8_9.isDirectory())) continue;
                                var6_7.add(var8_9);
                            }
                            if (var6_7.size() > 0) {
                                var4_4 = (File[])var6_7.toArray(new File[var6_7.size()]);
                            }
                            this.this$0.setDirectorySelected(false);
                        }
                    }
                    var2_2.setSelectedFiles(var4_4);
                    break block7;
                }
                var4_5 = (File)var3_3.getSelectedValue();
                if (var4_5 == null || !var4_5.isDirectory() || !var2_2.isTraversable(var4_5)) ** GOTO lbl-1000
                if (var2_2.getFileSelectionMode() != 1 || !var2_2.getFileSystemView().isFileSystem(var4_5)) {
                    this.this$0.setDirectorySelected(true);
                    this.this$0.setDirectory(var4_5);
                } else lbl-1000:
                // 2 sources

                {
                    this.this$0.setDirectorySelected(false);
                    if (var4_5 != null) {
                        var2_2.setSelectedFile(var4_5);
                    }
                }
            }
        }

        protected SelectionListener(BasicFileChooserUI basicFileChooserUI) {
            this.this$0 = basicFileChooserUI;
        }
    }

    protected class UpdateAction
    extends AbstractAction {
        private final BasicFileChooserUI this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = this.this$0.getFileChooser();
            jFileChooser.setCurrentDirectory(jFileChooser.getFileSystemView().createFileObject(this.this$0.getDirectoryName()));
            jFileChooser.rescanCurrentDirectory();
        }

        protected UpdateAction(BasicFileChooserUI basicFileChooserUI) {
            this.this$0 = basicFileChooserUI;
        }
    }
}

