/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StateInvariantError;
import javax.swing.text.Style;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.Utilities;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public class DefaultStyledDocument
extends AbstractDocument
implements StyledDocument {
    public static final int BUFFER_SIZE_DEFAULT = 4096;
    protected ElementBuffer buffer;
    private transient Vector listeningStyles = new Vector();
    private transient ChangeListener styleChangeListener;
    private transient ChangeListener styleContextChangeListener;
    private transient ChangeUpdateRunnable updateRunnable;
    static Class class$javax$swing$event$DocumentListener;

    public DefaultStyledDocument() {
        this((AbstractDocument.Content)new GapContent(4096), new StyleContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStylesListeningTo() {
        Vector vector = this.listeningStyles;
        synchronized (vector) {
            StyleContext styleContext = (StyleContext)this.getAttributeContext();
            if (this.styleChangeListener == null) {
                this.styleChangeListener = this.createStyleChangeListener();
            }
            if (this.styleChangeListener != null && styleContext != null) {
                Style style;
                Enumeration enumeration = styleContext.getStyleNames();
                Vector vector2 = (Vector)this.listeningStyles.clone();
                this.listeningStyles.removeAllElements();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    style = styleContext.getStyle(string);
                    int n2 = vector2.indexOf(style);
                    this.listeningStyles.addElement(style);
                    if (n2 == -1) {
                        style.addChangeListener(this.styleChangeListener);
                        continue;
                    }
                    vector2.removeElementAt(n2);
                }
                for (int i2 = vector2.size() - 1; i2 >= 0; --i2) {
                    style = (Style)vector2.elementAt(i2);
                    style.removeChangeListener(this.styleChangeListener);
                }
                if (this.listeningStyles.size() == 0) {
                    this.styleChangeListener = null;
                }
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.listeningStyles = new Vector();
        objectInputStream.defaultReadObject();
        if (this.styleContextChangeListener == null && this.listenerList.getListenerCount(class$javax$swing$event$DocumentListener == null ? (class$javax$swing$event$DocumentListener = DefaultStyledDocument.class$("javax.swing.event.DocumentListener")) : class$javax$swing$event$DocumentListener) > 0) {
            this.styleContextChangeListener = this.createStyleContextChangeListener();
            if (this.styleContextChangeListener != null) {
                StyleContext styleContext = (StyleContext)this.getAttributeContext();
                styleContext.addChangeListener(this.styleContextChangeListener);
            }
            this.updateStylesListeningTo();
        }
    }

    public void removeStyle(String string) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        styleContext.removeStyle(string);
    }

    public Enumeration getStyleNames() {
        return ((StyleContext)this.getAttributeContext()).getStyleNames();
    }

    ChangeListener createStyleChangeListener() {
        return new StyleChangeHandler(this);
    }

    ChangeListener createStyleContextChangeListener() {
        return new StyleContextChangeHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDocumentListener(DocumentListener documentListener) {
        Vector vector = this.listeningStyles;
        synchronized (vector) {
            int n2 = this.listenerList.getListenerCount(class$javax$swing$event$DocumentListener == null ? (class$javax$swing$event$DocumentListener = DefaultStyledDocument.class$("javax.swing.event.DocumentListener")) : class$javax$swing$event$DocumentListener);
            super.addDocumentListener(documentListener);
            if (n2 == 0) {
                if (this.styleContextChangeListener == null) {
                    this.styleContextChangeListener = this.createStyleContextChangeListener();
                }
                if (this.styleContextChangeListener != null) {
                    StyleContext styleContext = (StyleContext)this.getAttributeContext();
                    styleContext.addChangeListener(this.styleContextChangeListener);
                }
                this.updateStylesListeningTo();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDocumentListener(DocumentListener documentListener) {
        Vector vector = this.listeningStyles;
        synchronized (vector) {
            super.removeDocumentListener(documentListener);
            if (this.listenerList.getListenerCount(class$javax$swing$event$DocumentListener == null ? (class$javax$swing$event$DocumentListener = DefaultStyledDocument.class$("javax.swing.event.DocumentListener")) : class$javax$swing$event$DocumentListener) == 0) {
                for (int i2 = this.listeningStyles.size() - 1; i2 >= 0; --i2) {
                    ((Style)this.listeningStyles.elementAt(i2)).removeChangeListener(this.styleChangeListener);
                }
                this.listeningStyles.removeAllElements();
                if (this.styleContextChangeListener != null) {
                    StyleContext styleContext = (StyleContext)this.getAttributeContext();
                    styleContext.removeChangeListener(this.styleContextChangeListener);
                }
            }
        }
    }

    protected AbstractDocument.AbstractElement createDefaultRoot() {
        this.writeLock();
        SectionElement sectionElement = new SectionElement(this);
        AbstractDocument.BranchElement branchElement = new AbstractDocument.BranchElement(this, sectionElement, null);
        AbstractDocument.LeafElement leafElement = new AbstractDocument.LeafElement(this, branchElement, null, 0, 1);
        Element[] elementArray = new Element[]{leafElement};
        branchElement.replace(0, 0, elementArray);
        elementArray[0] = branchElement;
        sectionElement.replace(0, 0, elementArray);
        this.writeUnlock();
        return sectionElement;
    }

    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
        super.removeUpdate(defaultDocumentEvent);
        this.buffer.remove(defaultDocumentEvent.getOffset(), defaultDocumentEvent.getLength(), defaultDocumentEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharacterAttributes(int n2, int n3, AttributeSet attributeSet, boolean bl2) {
        try {
            Element element;
            this.writeLock();
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, n2, n3, DocumentEvent.EventType.CHANGE);
            this.buffer.change(n2, n3, defaultDocumentEvent);
            AttributeSet attributeSet2 = attributeSet.copyAttributes();
            int n4 = Integer.MAX_VALUE;
            int n5 = n2;
            while (n5 < n2 + n3 && n5 != (n4 = (element = this.getCharacterElement(n5)).getEndOffset())) {
                MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element.getAttributes();
                defaultDocumentEvent.addEdit(new AttributeUndoableEdit(element, attributeSet2, bl2));
                if (bl2) {
                    mutableAttributeSet.removeAttributes(mutableAttributeSet);
                }
                mutableAttributeSet.addAttributes(attributeSet);
                n5 = n4;
            }
            defaultDocumentEvent.end();
            this.fireChangedUpdate(defaultDocumentEvent);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParagraphAttributes(int n2, int n3, AttributeSet attributeSet, boolean bl2) {
        try {
            this.writeLock();
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, n2, n3, DocumentEvent.EventType.CHANGE);
            AttributeSet attributeSet2 = attributeSet.copyAttributes();
            Element element = this.getDefaultRootElement();
            int n4 = element.getElementIndex(n2);
            int n5 = element.getElementIndex(n2 + (n3 > 0 ? n3 - 1 : 0));
            boolean bl3 = Boolean.TRUE.equals(this.getProperty("i18n"));
            boolean bl4 = false;
            for (int i2 = n4; i2 <= n5; ++i2) {
                Element element2 = element.getElement(i2);
                MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)element2.getAttributes();
                defaultDocumentEvent.addEdit(new AttributeUndoableEdit(element2, attributeSet2, bl2));
                if (bl2) {
                    mutableAttributeSet.removeAttributes(mutableAttributeSet);
                }
                mutableAttributeSet.addAttributes(attributeSet);
                if (!bl3 || bl4) continue;
                bl4 = mutableAttributeSet.getAttribute(TextAttribute.RUN_DIRECTION) != null;
            }
            if (bl4) {
                this.updateBidi(defaultDocumentEvent);
            }
            defaultDocumentEvent.end();
            this.fireChangedUpdate(defaultDocumentEvent);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insert(int n2, ElementSpec[] elementSpecArray) throws BadLocationException {
        if (elementSpecArray == null || elementSpecArray.length == 0) {
            return;
        }
        try {
            this.writeLock();
            AbstractDocument.Content content = this.getContent();
            int n3 = elementSpecArray.length;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < n3; ++i2) {
                ElementSpec elementSpec = elementSpecArray[i2];
                if (elementSpec.getLength() <= 0) continue;
                stringBuffer.append(elementSpec.getArray(), elementSpec.getOffset(), elementSpec.getLength());
            }
            if (stringBuffer.length() == 0) {
                return;
            }
            UndoableEdit undoableEdit = content.insertString(n2, stringBuffer.toString());
            int n4 = stringBuffer.length();
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, n2, n4, DocumentEvent.EventType.INSERT);
            defaultDocumentEvent.addEdit(undoableEdit);
            this.buffer.insert(n2, n4, elementSpecArray, defaultDocumentEvent);
            super.insertUpdate(defaultDocumentEvent, null);
            defaultDocumentEvent.end();
            this.fireInsertUpdate(defaultDocumentEvent);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
        }
        finally {
            this.writeUnlock();
        }
    }

    protected void create(ElementSpec[] elementSpecArray) {
        try {
            if (this.getLength() != 0) {
                this.remove(0, this.getLength());
            }
            this.writeLock();
            AbstractDocument.Content content = this.getContent();
            int n2 = elementSpecArray.length;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < n2; ++i2) {
                ElementSpec elementSpec = elementSpecArray[i2];
                if (elementSpec.getLength() <= 0) continue;
                stringBuffer.append(elementSpec.getArray(), elementSpec.getOffset(), elementSpec.getLength());
            }
            UndoableEdit undoableEdit = content.insertString(0, stringBuffer.toString());
            int n3 = stringBuffer.length();
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, 0, n3, DocumentEvent.EventType.INSERT);
            defaultDocumentEvent.addEdit(undoableEdit);
            this.buffer.create(n3, elementSpecArray, defaultDocumentEvent);
            super.insertUpdate(defaultDocumentEvent, null);
            defaultDocumentEvent.end();
            this.fireInsertUpdate(defaultDocumentEvent);
            this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
        }
        catch (BadLocationException badLocationException) {
            throw new StateInvariantError("problem initializing");
        }
        finally {
            this.writeUnlock();
        }
    }

    public Element getDefaultRootElement() {
        return this.buffer.getRootElement();
    }

    public Element getCharacterElement(int n2) {
        Element element = null;
        element = this.getDefaultRootElement();
        while (!element.isLeaf()) {
            int n3 = element.getElementIndex(n2);
            element = element.getElement(n3);
        }
        return element;
    }

    public Element getParagraphElement(int n2) {
        Element element = null;
        element = this.getDefaultRootElement();
        while (!element.isLeaf()) {
            int n3 = element.getElementIndex(n2);
            element = element.getElement(n3);
        }
        if (element != null) {
            return element.getParentElement();
        }
        return element;
    }

    public Style getLogicalStyle(int n2) {
        AttributeSet attributeSet;
        AttributeSet attributeSet2;
        Style style = null;
        Element element = this.getParagraphElement(n2);
        if (element != null && (attributeSet2 = (attributeSet = element.getAttributes()).getResolveParent()) instanceof Style) {
            style = (Style)attributeSet2;
        }
        return style;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogicalStyle(int n2, Style style) {
        Element element = this.getParagraphElement(n2);
        if (element != null && element instanceof AbstractDocument.AbstractElement) {
            try {
                this.writeLock();
                StyleChangeUndoableEdit styleChangeUndoableEdit = new StyleChangeUndoableEdit((AbstractDocument.AbstractElement)element, style);
                ((AbstractDocument.AbstractElement)element).setResolveParent(style);
                int n3 = element.getStartOffset();
                int n4 = element.getEndOffset();
                AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, n3, n4 - n3, DocumentEvent.EventType.CHANGE);
                defaultDocumentEvent.addEdit(styleChangeUndoableEdit);
                defaultDocumentEvent.end();
                this.fireChangedUpdate(defaultDocumentEvent);
                this.fireUndoableEditUpdate(new UndoableEditEvent(this, defaultDocumentEvent));
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void styleChanged(Style style) {
        if (this.getLength() != 0) {
            if (this.updateRunnable == null) {
                this.updateRunnable = new ChangeUpdateRunnable(this);
            }
            ChangeUpdateRunnable changeUpdateRunnable = this.updateRunnable;
            synchronized (changeUpdateRunnable) {
                if (!this.updateRunnable.isPending) {
                    SwingUtilities.invokeLater(this.updateRunnable);
                    this.updateRunnable.isPending = true;
                }
            }
        }
    }

    public DefaultStyledDocument(StyleContext styleContext) {
        this((AbstractDocument.Content)new GapContent(4096), styleContext);
    }

    public Color getBackground(AttributeSet attributeSet) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getBackground(attributeSet);
    }

    public Color getForeground(AttributeSet attributeSet) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getForeground(attributeSet);
    }

    public Font getFont(AttributeSet attributeSet) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getFont(attributeSet);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        int n2 = defaultDocumentEvent.getOffset();
        int n3 = defaultDocumentEvent.getLength();
        if (attributeSet == null) {
            attributeSet = SimpleAttributeSet.EMPTY;
        }
        Element element = this.getParagraphElement(n2 + n3);
        AttributeSet attributeSet2 = element.getAttributes();
        Element element2 = this.getParagraphElement(n2);
        Element element3 = element2.getElement(element2.getElementIndex(n2));
        int n4 = n2 + n3;
        boolean bl2 = element3.getEndOffset() == n4;
        AttributeSet attributeSet3 = element3.getAttributes();
        try {
            Object object;
            int n5;
            Segment segment = new Segment();
            Vector vector = new Vector();
            ElementSpec elementSpec = null;
            boolean bl3 = false;
            short s2 = 6;
            if (n2 > 0) {
                this.getText(n2 - 1, 1, segment);
                if (segment.array[segment.offset] == '\n') {
                    bl3 = true;
                    s2 = this.createSpecsForInsertAfterNewline(element, element2, attributeSet2, vector, n2, n4);
                    for (int i2 = vector.size() - 1; i2 >= 0; --i2) {
                        ElementSpec elementSpec2 = (ElementSpec)vector.elementAt(i2);
                        if (elementSpec2.getType() != 1) continue;
                        elementSpec = elementSpec2;
                        break;
                    }
                }
            }
            if (!bl3) {
                attributeSet2 = element2.getAttributes();
            }
            this.getText(n2, n3, segment);
            char[] cArray = segment.array;
            int n6 = segment.offset + segment.count;
            int n7 = segment.offset;
            for (int i3 = segment.offset; i3 < n6; ++i3) {
                if (cArray[i3] != '\n') continue;
                n5 = i3 + 1;
                vector.addElement(new ElementSpec(attributeSet, 3, n5 - n7));
                vector.addElement(new ElementSpec(null, 2));
                elementSpec = new ElementSpec(attributeSet2, 1);
                vector.addElement(elementSpec);
                n7 = n5;
            }
            if (n7 < n6) {
                vector.addElement(new ElementSpec(attributeSet, 3, n6 - n7));
            }
            ElementSpec elementSpec3 = (ElementSpec)vector.firstElement();
            n5 = this.getLength();
            if (elementSpec3.getType() == 3 && attributeSet3.isEqual(attributeSet)) {
                elementSpec3.setDirection((short)4);
            }
            if (elementSpec != null) {
                if (bl3) {
                    elementSpec.setDirection(s2);
                } else if (element2.getEndOffset() != n4) {
                    elementSpec.setDirection((short)7);
                } else {
                    object = element2.getParentElement();
                    int n8 = object.getElementIndex(n2);
                    if (n8 + 1 < object.getElementCount() && !object.getElement(n8 + 1).isLeaf()) {
                        elementSpec.setDirection((short)5);
                    }
                }
            }
            if (bl2 && n4 < n5) {
                Element element4;
                object = (ElementSpec)vector.lastElement();
                if (((ElementSpec)object).getType() == 3 && ((ElementSpec)object).getDirection() != 4 && (elementSpec == null && (element == element2 || bl3) || elementSpec != null && elementSpec.getDirection() != 6) && (element4 = element.getElement(element.getElementIndex(n4))).isLeaf() && attributeSet.isEqual(element4.getAttributes())) {
                    ((ElementSpec)object).setDirection((short)5);
                }
            } else if (!bl2 && elementSpec != null && elementSpec.getDirection() == 7 && ((ElementSpec)(object = (ElementSpec)vector.lastElement())).getType() == 3 && ((ElementSpec)object).getDirection() != 4 && attributeSet.isEqual(attributeSet3)) {
                ((ElementSpec)object).setDirection((short)5);
            }
            if (Utilities.isComposedTextAttributeDefined(attributeSet)) {
                ((MutableAttributeSet)attributeSet).addAttributes(attributeSet3);
                ((MutableAttributeSet)attributeSet).addAttribute("$ename", "content");
            }
            object = new ElementSpec[vector.size()];
            vector.copyInto((Object[])object);
            this.buffer.insert(n2, n3, (ElementSpec[])object, defaultDocumentEvent);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        super.insertUpdate(defaultDocumentEvent, attributeSet);
    }

    public Style getStyle(String string) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getStyle(string);
    }

    public DefaultStyledDocument(AbstractDocument.Content content, StyleContext styleContext) {
        super(content, styleContext);
        this.buffer = new ElementBuffer(this, this.createDefaultRoot());
        Style style = styleContext.getStyle("default");
        this.setLogicalStyle(0, style);
    }

    public Style addStyle(String string, Style style) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.addStyle(string, style);
    }

    short createSpecsForInsertAfterNewline(Element element, Element element2, AttributeSet attributeSet, Vector vector, int n2, int n3) {
        if (element.getParentElement() == element2.getParentElement()) {
            ElementSpec elementSpec = new ElementSpec(attributeSet, 2);
            vector.addElement(elementSpec);
            elementSpec = new ElementSpec(attributeSet, 1);
            vector.addElement(elementSpec);
            if (element2.getEndOffset() != n3) {
                return 7;
            }
            Element element3 = element2.getParentElement();
            if (element3.getElementIndex(n2) + 1 < element3.getElementCount()) {
                return 5;
            }
        } else {
            Element element4;
            Vector vector2 = new Vector();
            Vector vector3 = new Vector();
            for (element4 = element2; element4 != null; element4 = element4.getParentElement()) {
                vector2.addElement(element4);
            }
            int n4 = -1;
            for (element4 = element; element4 != null && (n4 = vector2.indexOf(element4)) == -1; element4 = element4.getParentElement()) {
                vector3.addElement(element4);
            }
            if (element4 != null) {
                for (int i2 = 0; i2 < n4; ++i2) {
                    vector.addElement(new ElementSpec(null, 2));
                }
                ElementSpec elementSpec = null;
                for (int i3 = vector3.size() - 1; i3 >= 0; --i3) {
                    elementSpec = new ElementSpec(((Element)vector3.elementAt(i3)).getAttributes(), 1);
                    if (i3 > 0) {
                        elementSpec.setDirection((short)5);
                    }
                    vector.addElement(elementSpec);
                }
                if (vector3.size() > 0) {
                    return 5;
                }
                return 7;
            }
        }
        return 6;
    }

    public static class AttributeUndoableEdit
    extends AbstractUndoableEdit {
        protected AttributeSet newAttributes;
        protected AttributeSet copy;
        protected boolean isReplacing;
        protected Element element;

        public void redo() throws CannotRedoException {
            super.redo();
            MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)this.element.getAttributes();
            if (this.isReplacing) {
                mutableAttributeSet.removeAttributes(mutableAttributeSet);
            }
            mutableAttributeSet.addAttributes(this.newAttributes);
        }

        public void undo() throws CannotUndoException {
            super.undo();
            MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)this.element.getAttributes();
            mutableAttributeSet.removeAttributes(mutableAttributeSet);
            mutableAttributeSet.addAttributes(this.copy);
        }

        public AttributeUndoableEdit(Element element, AttributeSet attributeSet, boolean bl2) {
            this.element = element;
            this.newAttributes = attributeSet;
            this.isReplacing = bl2;
            this.copy = element.getAttributes().copyAttributes();
        }
    }

    class ChangeUpdateRunnable
    implements Runnable {
        boolean isPending;
        private final DefaultStyledDocument this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this;
            synchronized (object) {
                this.isPending = false;
            }
            try {
                this.this$0.writeLock();
                object = new AbstractDocument.DefaultDocumentEvent(this.this$0, 0, this.this$0.getLength(), DocumentEvent.EventType.CHANGE);
                ((CompoundEdit)object).end();
                this.this$0.fireChangedUpdate((DocumentEvent)object);
            }
            finally {
                this.this$0.writeUnlock();
            }
        }

        ChangeUpdateRunnable(DefaultStyledDocument defaultStyledDocument) {
            this.this$0 = defaultStyledDocument;
            this.isPending = false;
        }
    }

    public class ElementBuffer
    implements Serializable {
        Element root;
        transient int pos;
        transient int offset;
        transient int length;
        transient int endOffset;
        transient Vector changes;
        transient Stack path;
        transient boolean insertOp;
        transient boolean recreateLeafs;
        transient ElemChanges[] insertPath;
        transient boolean createdFracture;
        transient Element fracturedParent;
        transient Element fracturedChild;
        transient boolean offsetLastIndex;
        transient boolean offsetLastIndexOnReplace;
        private final DefaultStyledDocument this$0;

        protected void changeUpdate() {
            boolean bl2 = this.split(this.offset, this.length);
            if (!bl2) {
                while (this.path.size() != 0) {
                    this.pop();
                }
                this.split(this.offset + this.length, 0);
            }
            while (this.path.size() != 0) {
                this.pop();
            }
        }

        void pop() {
            Element element;
            ElemChanges elemChanges = (ElemChanges)this.path.peek();
            this.path.pop();
            if (elemChanges.added.size() > 0 || elemChanges.removed.size() > 0) {
                this.changes.addElement(elemChanges);
            } else if (!this.path.isEmpty() && (element = elemChanges.parent).getElementCount() == 0) {
                elemChanges = (ElemChanges)this.path.peek();
                elemChanges.added.removeElement(element);
            }
        }

        protected void removeUpdate() {
            this.removeElements(this.root, this.offset, this.offset + this.length);
        }

        void advance(int n2) {
            this.pos += n2;
        }

        void fracture(int n2) {
            int n3 = this.insertPath.length;
            int n4 = -1;
            boolean bl2 = this.recreateLeafs;
            ElemChanges elemChanges = this.insertPath[n3 - 1];
            boolean bl3 = elemChanges.index + 1 < elemChanges.parent.getElementCount();
            int n5 = bl2 ? n3 : -1;
            int n6 = n3 - 1;
            this.createdFracture = true;
            for (int i2 = n3 - 2; i2 >= 0; --i2) {
                ElemChanges elemChanges2 = this.insertPath[i2];
                if (elemChanges2.added.size() > 0 || i2 == n2) {
                    n4 = i2;
                    if (!bl2 && bl3) {
                        bl2 = true;
                        if (n5 == -1) {
                            n5 = n6 + 1;
                        }
                    }
                }
                if (bl3 || elemChanges2.index >= elemChanges2.parent.getElementCount()) continue;
                bl3 = true;
                n6 = i2;
            }
            if (bl2) {
                if (n4 == -1) {
                    n4 = n3 - 1;
                }
                this.fractureFrom(this.insertPath, n4, n5);
            }
        }

        void beginEdits(int n2, int n3) {
            this.offset = n2;
            this.length = n3;
            this.endOffset = n2 + n3;
            this.pos = n2;
            if (this.changes == null) {
                this.changes = new Vector();
            } else {
                this.changes.removeAllElements();
            }
            if (this.path == null) {
                this.path = new Stack();
            } else {
                this.path.removeAllElements();
            }
            this.fracturedParent = null;
            this.fracturedChild = null;
            this.offsetLastIndexOnReplace = false;
            this.offsetLastIndex = false;
        }

        boolean split(int n2, int n3) {
            boolean bl2 = false;
            Element element = this.root;
            int n4 = element.getElementIndex(n2);
            while (!element.isLeaf()) {
                this.push(element, n4);
                element = element.getElement(n4);
                n4 = element.getElementIndex(n2);
            }
            ElemChanges elemChanges = (ElemChanges)this.path.peek();
            Element element2 = elemChanges.parent.getElement(elemChanges.index);
            if (element2.getStartOffset() < n2 && n2 < element2.getEndOffset()) {
                int n5;
                int n6 = n5 = elemChanges.index;
                if (n2 + n3 < elemChanges.parent.getEndOffset() && n3 != 0) {
                    n6 = elemChanges.parent.getElementIndex(n2 + n3);
                    if (n6 == n5) {
                        elemChanges.removed.addElement(element2);
                        element = this.this$0.createLeafElement(elemChanges.parent, element2.getAttributes(), element2.getStartOffset(), n2);
                        elemChanges.added.addElement(element);
                        element = this.this$0.createLeafElement(elemChanges.parent, element2.getAttributes(), n2, n2 + n3);
                        elemChanges.added.addElement(element);
                        element = this.this$0.createLeafElement(elemChanges.parent, element2.getAttributes(), n2 + n3, element2.getEndOffset());
                        elemChanges.added.addElement(element);
                        return true;
                    }
                    element2 = elemChanges.parent.getElement(n6);
                    if (n2 + n3 == element2.getStartOffset()) {
                        n6 = n5;
                    }
                    bl2 = true;
                }
                this.pos = n2;
                element2 = elemChanges.parent.getElement(n5);
                elemChanges.removed.addElement(element2);
                element = this.this$0.createLeafElement(elemChanges.parent, element2.getAttributes(), element2.getStartOffset(), this.pos);
                elemChanges.added.addElement(element);
                element = this.this$0.createLeafElement(elemChanges.parent, element2.getAttributes(), this.pos, element2.getEndOffset());
                elemChanges.added.addElement(element);
                for (int i2 = n5 + 1; i2 < n6; ++i2) {
                    element2 = elemChanges.parent.getElement(i2);
                    elemChanges.removed.addElement(element2);
                    elemChanges.added.addElement(element2);
                }
                if (n6 != n5) {
                    element2 = elemChanges.parent.getElement(n6);
                    this.pos = n2 + n3;
                    elemChanges.removed.addElement(element2);
                    element = this.this$0.createLeafElement(elemChanges.parent, element2.getAttributes(), element2.getStartOffset(), this.pos);
                    elemChanges.added.addElement(element);
                    element = this.this$0.createLeafElement(elemChanges.parent, element2.getAttributes(), this.pos, element2.getEndOffset());
                    elemChanges.added.addElement(element);
                }
            }
            return bl2;
        }

        public void change(int n2, int n3, AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            this.beginEdits(n2, n3);
            this.changeUpdate();
            this.endEdits(defaultDocumentEvent);
        }

        public void remove(int n2, int n3, AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            this.beginEdits(n2, n3);
            this.removeUpdate();
            this.endEdits(defaultDocumentEvent);
        }

        void endEdits(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            int n2 = this.changes.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ElemChanges elemChanges = (ElemChanges)this.changes.elementAt(i2);
                Object[] objectArray = new Element[elemChanges.removed.size()];
                elemChanges.removed.copyInto(objectArray);
                Object[] objectArray2 = new Element[elemChanges.added.size()];
                elemChanges.added.copyInto(objectArray2);
                int n3 = elemChanges.index;
                ((AbstractDocument.BranchElement)elemChanges.parent).replace(n3, objectArray.length, (Element[])objectArray2);
                AbstractDocument.ElementEdit elementEdit = new AbstractDocument.ElementEdit((AbstractDocument.BranchElement)elemChanges.parent, n3, (Element[])objectArray, (Element[])objectArray2);
                defaultDocumentEvent.addEdit(elementEdit);
            }
            this.changes.removeAllElements();
            this.path.removeAllElements();
        }

        void fractureFrom(ElemChanges[] elemChangesArray, int n2, int n3) {
            ElemChanges elemChanges = elemChangesArray[n2];
            int n4 = elemChangesArray.length;
            Object object = n2 + 1 == n4 ? elemChanges.parent.getElement(elemChanges.index) : elemChanges.parent.getElement(elemChanges.index - 1);
            Element element = object.isLeaf() ? this.this$0.createLeafElement(elemChanges.parent, object.getAttributes(), Math.max(this.endOffset, object.getStartOffset()), object.getEndOffset()) : this.this$0.createBranchElement(elemChanges.parent, object.getAttributes());
            this.fracturedParent = elemChanges.parent;
            this.fracturedChild = element;
            Element element2 = element;
            while (++n2 < n3) {
                Element[] elementArray;
                int n5;
                boolean bl2 = n2 + 1 == n3;
                boolean bl3 = n2 + 1 == n4;
                elemChanges = elemChangesArray[n2];
                object = bl2 ? (this.offsetLastIndex || !bl3 ? null : elemChanges.parent.getElement(elemChanges.index)) : elemChanges.parent.getElement(elemChanges.index - 1);
                element = object != null ? (object.isLeaf() ? this.this$0.createLeafElement(element2, object.getAttributes(), Math.max(this.endOffset, object.getStartOffset()), object.getEndOffset()) : this.this$0.createBranchElement(element2, object.getAttributes())) : null;
                int n6 = elemChanges.parent.getElementCount() - elemChanges.index;
                int n7 = 1;
                if (element == null) {
                    if (bl3) {
                        --n6;
                        n5 = elemChanges.index + 1;
                    } else {
                        n5 = elemChanges.index;
                    }
                    n7 = 0;
                    elementArray = new Element[n6];
                } else {
                    if (!bl2) {
                        ++n6;
                        n5 = elemChanges.index;
                    } else {
                        n5 = elemChanges.index + 1;
                    }
                    elementArray = new Element[n6];
                    elementArray[0] = element;
                }
                for (int i2 = n7; i2 < n6; ++i2) {
                    Element element3 = elemChanges.parent.getElement(n5++);
                    elementArray[i2] = this.recreateFracturedElement(element2, element3);
                    elemChanges.removed.addElement(element3);
                }
                ((AbstractDocument.BranchElement)element2).replace(0, 0, elementArray);
                element2 = element;
            }
        }

        void insertElement(ElementSpec elementSpec) {
            ElemChanges elemChanges = (ElemChanges)this.path.peek();
            block0 : switch (elementSpec.getType()) {
                case 1: {
                    switch (elementSpec.getDirection()) {
                        case 5: {
                            Element element = elemChanges.parent.getElement(elemChanges.index);
                            if (element.isLeaf()) {
                                if (elemChanges.index + 1 < elemChanges.parent.getElementCount()) {
                                    element = elemChanges.parent.getElement(elemChanges.index + 1);
                                } else {
                                    throw new StateInvariantError("Join next to leaf");
                                }
                            }
                            this.push(element, 0, true);
                            break block0;
                        }
                        case 7: {
                            if (!this.createdFracture) {
                                this.fracture(this.path.size() - 1);
                            }
                            if (!elemChanges.isFracture) {
                                this.push(this.fracturedChild, 0, true);
                                break block0;
                            }
                            this.push(elemChanges.parent.getElement(0), 0, true);
                            break block0;
                        }
                    }
                    Element element = this.this$0.createBranchElement(elemChanges.parent, elementSpec.getAttributes());
                    elemChanges.added.addElement(element);
                    this.push(element, 0);
                    break;
                }
                case 2: {
                    this.pop();
                    break;
                }
                case 3: {
                    int n2 = elementSpec.getLength();
                    if (elementSpec.getDirection() != 5) {
                        Element element = this.this$0.createLeafElement(elemChanges.parent, elementSpec.getAttributes(), this.pos, this.pos + n2);
                        elemChanges.added.addElement(element);
                    } else if (!elemChanges.isFracture) {
                        Element element = null;
                        if (this.insertPath != null) {
                            for (int i2 = this.insertPath.length - 1; i2 >= 0; --i2) {
                                if (this.insertPath[i2] != elemChanges) continue;
                                if (i2 == this.insertPath.length - 1) break;
                                element = elemChanges.parent.getElement(elemChanges.index);
                                break;
                            }
                        }
                        if (element == null) {
                            element = elemChanges.parent.getElement(elemChanges.index + 1);
                        }
                        Element element2 = this.this$0.createLeafElement(elemChanges.parent, element.getAttributes(), this.pos, element.getEndOffset());
                        elemChanges.added.addElement(element2);
                        elemChanges.removed.addElement(element);
                    } else {
                        Element element = elemChanges.parent.getElement(0);
                        Element element3 = this.this$0.createLeafElement(elemChanges.parent, element.getAttributes(), this.pos, element.getEndOffset());
                        elemChanges.added.addElement(element3);
                        elemChanges.removed.addElement(element);
                    }
                    this.pos += n2;
                }
            }
        }

        void fractureDeepestLeaf(ElementSpec[] elementSpecArray) {
            ElemChanges elemChanges = (ElemChanges)this.path.peek();
            Element element = elemChanges.parent.getElement(elemChanges.index);
            if (this.offset != 0) {
                Element element2 = this.this$0.createLeafElement(elemChanges.parent, element.getAttributes(), element.getStartOffset(), this.offset);
                elemChanges.added.addElement(element2);
            }
            elemChanges.removed.addElement(element);
            if (element.getEndOffset() != this.endOffset) {
                this.recreateLeafs = true;
            } else {
                this.offsetLastIndex = true;
            }
        }

        void insertFirstContent(ElementSpec[] elementSpecArray) {
            ElementSpec elementSpec = elementSpecArray[0];
            ElemChanges elemChanges = (ElemChanges)this.path.peek();
            Element element = elemChanges.parent.getElement(elemChanges.index);
            int n2 = this.offset + elementSpec.getLength();
            boolean bl2 = elementSpecArray.length == 1;
            switch (elementSpec.getDirection()) {
                case 4: {
                    if (element.getEndOffset() != n2 && !bl2) {
                        Element element2 = this.this$0.createLeafElement(elemChanges.parent, element.getAttributes(), element.getStartOffset(), n2);
                        elemChanges.added.addElement(element2);
                        elemChanges.removed.addElement(element);
                        if (element.getEndOffset() != this.endOffset) {
                            this.recreateLeafs = true;
                            break;
                        }
                        this.offsetLastIndex = true;
                        break;
                    }
                    this.offsetLastIndex = true;
                    this.offsetLastIndexOnReplace = true;
                    break;
                }
                case 5: {
                    if (this.offset == 0) break;
                    Element element3 = this.this$0.createLeafElement(elemChanges.parent, element.getAttributes(), element.getStartOffset(), this.offset);
                    elemChanges.added.addElement(element3);
                    Element element4 = elemChanges.parent.getElement(elemChanges.index + 1);
                    element3 = bl2 ? this.this$0.createLeafElement(elemChanges.parent, element4.getAttributes(), this.offset, element4.getEndOffset()) : this.this$0.createLeafElement(elemChanges.parent, element4.getAttributes(), this.offset, n2);
                    elemChanges.added.addElement(element3);
                    elemChanges.removed.addElement(element);
                    elemChanges.removed.addElement(element4);
                    break;
                }
                default: {
                    Element element5;
                    if (element.getStartOffset() != this.offset) {
                        element5 = this.this$0.createLeafElement(elemChanges.parent, element.getAttributes(), element.getStartOffset(), this.offset);
                        elemChanges.added.addElement(element5);
                    }
                    elemChanges.removed.addElement(element);
                    element5 = this.this$0.createLeafElement(elemChanges.parent, elementSpec.getAttributes(), this.offset, n2);
                    elemChanges.added.addElement(element5);
                    if (element.getEndOffset() != this.endOffset) {
                        this.recreateLeafs = true;
                        break;
                    }
                    this.offsetLastIndex = true;
                }
            }
        }

        protected void insertUpdate(ElementSpec[] elementSpecArray) {
            ElemChanges elemChanges;
            int n2;
            int n3;
            Element element = this.root;
            int n4 = element.getElementIndex(this.offset);
            while (!element.isLeaf()) {
                Element element2 = element.getElement(n4);
                this.push(element, element2.isLeaf() ? n4 : n4 + 1);
                element = element2;
                n4 = element.getElementIndex(this.offset);
            }
            this.insertPath = new ElemChanges[this.path.size()];
            this.path.copyInto(this.insertPath);
            this.createdFracture = false;
            this.recreateLeafs = false;
            if (elementSpecArray[0].getType() == 3) {
                this.insertFirstContent(elementSpecArray);
                this.pos += elementSpecArray[0].getLength();
                n3 = 1;
            } else {
                this.fractureDeepestLeaf(elementSpecArray);
                n3 = 0;
            }
            int n5 = elementSpecArray.length;
            while (n3 < n5) {
                this.insertElement(elementSpecArray[n3]);
                ++n3;
            }
            if (!this.createdFracture) {
                this.fracture(-1);
            }
            while (this.path.size() != 0) {
                this.pop();
            }
            if (this.offsetLastIndex && this.offsetLastIndexOnReplace) {
                ++this.insertPath[this.insertPath.length - 1].index;
            }
            for (n2 = this.insertPath.length - 1; n2 >= 0; --n2) {
                elemChanges = this.insertPath[n2];
                if (elemChanges.parent == this.fracturedParent) {
                    elemChanges.added.addElement(this.fracturedChild);
                }
                if (elemChanges.added.size() <= 0 && elemChanges.removed.size() <= 0 || this.changes.contains(elemChanges)) continue;
                this.changes.addElement(elemChanges);
            }
            if (this.offset == 0 && this.fracturedParent != null && elementSpecArray[0].getType() == 2) {
                for (n2 = 0; n2 < elementSpecArray.length && elementSpecArray[n2].getType() == 2; ++n2) {
                }
                elemChanges = this.insertPath[this.insertPath.length - n2 - 1];
                elemChanges.removed.insertElementAt(elemChanges.parent.getElement(--elemChanges.index), 0);
            }
        }

        public Element getRootElement() {
            return this.root;
        }

        void push(Element element, int n2) {
            this.push(element, n2, false);
        }

        boolean removeElements(Element element, int n2, int n3) {
            if (!element.isLeaf()) {
                int n4 = element.getElementIndex(n2);
                int n5 = element.getElementIndex(n3);
                this.push(element, n4);
                ElemChanges elemChanges = (ElemChanges)this.path.peek();
                if (n4 == n5) {
                    Element element2 = element.getElement(n4);
                    if (n2 <= element2.getStartOffset() && n3 >= element2.getEndOffset()) {
                        elemChanges.removed.addElement(element2);
                    } else if (this.removeElements(element2, n2, n3)) {
                        elemChanges.removed.addElement(element2);
                    }
                } else {
                    boolean bl2;
                    Element element3 = element.getElement(n4);
                    Element element4 = element.getElement(n5);
                    boolean bl3 = bl2 = n3 < element.getEndOffset();
                    if (bl2 && this.canJoin(element3, element4)) {
                        for (int i2 = n4; i2 <= n5; ++i2) {
                            elemChanges.removed.addElement(element.getElement(i2));
                        }
                        Element element5 = this.join(element, element3, element4, n2, n3);
                        elemChanges.added.addElement(element5);
                    } else {
                        int n6 = n4 + 1;
                        int n7 = n5 - 1;
                        if (element3.getStartOffset() == n2 || n4 == 0 && element3.getStartOffset() > n2 && element3.getEndOffset() <= n3) {
                            element3 = null;
                            n6 = n4;
                        }
                        if (!bl2) {
                            element4 = null;
                            ++n7;
                        } else if (element4.getStartOffset() == n3) {
                            element4 = null;
                        }
                        if (n6 <= n7) {
                            elemChanges.index = n6;
                        }
                        for (int i3 = n6; i3 <= n7; ++i3) {
                            elemChanges.removed.addElement(element.getElement(i3));
                        }
                        if (element3 != null && this.removeElements(element3, n2, n3)) {
                            elemChanges.removed.insertElementAt(element3, 0);
                            elemChanges.index = n4;
                        }
                        if (element4 != null && this.removeElements(element4, n2, n3)) {
                            elemChanges.removed.addElement(element4);
                        }
                    }
                }
                this.pop();
                if (element.getElementCount() == elemChanges.removed.size() - elemChanges.added.size()) {
                    return true;
                }
            }
            return false;
        }

        void push(Element element, int n2, boolean bl2) {
            ElemChanges elemChanges = new ElemChanges(this, element, n2, bl2);
            this.path.push(elemChanges);
        }

        public void insert(int n2, int n3, ElementSpec[] elementSpecArray, AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            if (n3 == 0) {
                return;
            }
            this.insertOp = true;
            this.beginEdits(n2, n3);
            this.insertUpdate(elementSpecArray);
            this.endEdits(defaultDocumentEvent);
            this.insertOp = false;
        }

        void create(int n2, ElementSpec[] elementSpecArray, AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            Object object;
            this.insertOp = true;
            this.beginEdits(this.offset, n2);
            Object object2 = this.root;
            int n3 = object2.getElementIndex(0);
            while (!object2.isLeaf()) {
                object = object2.getElement(n3);
                this.push((Element)object2, n3);
                object2 = object;
                n3 = object2.getElementIndex(0);
            }
            object = (ElemChanges)this.path.peek();
            Element element = ((ElemChanges)object).parent.getElement(((ElemChanges)object).index);
            ((ElemChanges)object).added.addElement(this.this$0.createLeafElement(((ElemChanges)object).parent, element.getAttributes(), this.this$0.getLength(), element.getEndOffset()));
            ((ElemChanges)object).removed.addElement(element);
            while (this.path.size() > 1) {
                this.pop();
            }
            int n4 = elementSpecArray.length;
            AttributeSet attributeSet = null;
            if (n4 > 0 && elementSpecArray[0].getType() == 1) {
                attributeSet = elementSpecArray[0].getAttributes();
            }
            if (attributeSet == null) {
                attributeSet = SimpleAttributeSet.EMPTY;
            }
            MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)this.root.getAttributes();
            defaultDocumentEvent.addEdit(new AttributeUndoableEdit(this.root, attributeSet, true));
            mutableAttributeSet.removeAttributes(mutableAttributeSet);
            mutableAttributeSet.addAttributes(attributeSet);
            for (int i2 = 1; i2 < n4; ++i2) {
                this.insertElement(elementSpecArray[i2]);
            }
            while (this.path.size() != 0) {
                this.pop();
            }
            this.endEdits(defaultDocumentEvent);
            this.insertOp = false;
        }

        public ElementBuffer(DefaultStyledDocument defaultStyledDocument, Element element) {
            this.this$0 = defaultStyledDocument;
            this.root = element;
            this.changes = new Vector();
            this.path = new Stack();
        }

        boolean canJoin(Element element, Element element2) {
            boolean bl2;
            if (element == null || element2 == null) {
                return false;
            }
            boolean bl3 = element.isLeaf();
            if (bl3 != (bl2 = element2.isLeaf())) {
                return false;
            }
            if (bl3) {
                return element.getAttributes().isEqual(element2.getAttributes());
            }
            String string = element.getName();
            String string2 = element2.getName();
            if (string != null) {
                return string.equals(string2);
            }
            if (string2 != null) {
                return string2.equals(string);
            }
            return true;
        }

        public Element clone(Element element, Element element2) {
            if (element2.isLeaf()) {
                return this.this$0.createLeafElement(element, element2.getAttributes(), element2.getStartOffset(), element2.getEndOffset());
            }
            Element element3 = this.this$0.createBranchElement(element, element2.getAttributes());
            int n2 = element2.getElementCount();
            Element[] elementArray = new Element[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                elementArray[i2] = this.clone(element3, element2.getElement(i2));
            }
            ((AbstractDocument.BranchElement)element3).replace(0, 0, elementArray);
            return element3;
        }

        Element recreateFracturedElement(Element element, Element element2) {
            if (element2.isLeaf()) {
                return this.this$0.createLeafElement(element, element2.getAttributes(), Math.max(element2.getStartOffset(), this.endOffset), element2.getEndOffset());
            }
            Element element3 = this.this$0.createBranchElement(element, element2.getAttributes());
            int n2 = element2.getElementCount();
            Element[] elementArray = new Element[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                elementArray[i2] = this.recreateFracturedElement(element3, element2.getElement(i2));
            }
            ((AbstractDocument.BranchElement)element3).replace(0, 0, elementArray);
            return element3;
        }

        Element cloneAsNecessary(Element element, Element element2, int n2, int n3) {
            if (element2.isLeaf()) {
                return this.this$0.createLeafElement(element, element2.getAttributes(), element2.getStartOffset(), element2.getEndOffset());
            }
            Element element3 = this.this$0.createBranchElement(element, element2.getAttributes());
            int n4 = element2.getElementCount();
            ArrayList arrayList = new ArrayList(n4);
            for (int i2 = 0; i2 < n4; ++i2) {
                Element element4 = element2.getElement(i2);
                if (element4.getStartOffset() >= n2 && element4.getEndOffset() <= n3) continue;
                arrayList.add(this.cloneAsNecessary(element3, element4, n2, n3));
            }
            Object[] objectArray = new Element[arrayList.size()];
            objectArray = (Element[])arrayList.toArray(objectArray);
            ((AbstractDocument.BranchElement)element3).replace(0, 0, (Element[])objectArray);
            return element3;
        }

        Element join(Element element, Element element2, Element element3, int n2, int n3) {
            if (element2.isLeaf() && element3.isLeaf()) {
                return this.this$0.createLeafElement(element, element2.getAttributes(), element2.getStartOffset(), element3.getEndOffset());
            }
            if (!element2.isLeaf() && !element3.isLeaf()) {
                int n4;
                Element element4;
                Element element5 = this.this$0.createBranchElement(element, element2.getAttributes());
                int n5 = element2.getElementIndex(n2);
                int n6 = element3.getElementIndex(n3);
                Element element6 = element2.getElement(n5);
                if (element6.getStartOffset() >= n2) {
                    element6 = null;
                }
                if ((element4 = element3.getElement(n6)).getStartOffset() == n3) {
                    element4 = null;
                }
                Vector vector = new Vector();
                for (int i2 = 0; i2 < n5; ++i2) {
                    vector.addElement(this.clone(element5, element2.getElement(i2)));
                }
                if (this.canJoin(element6, element4)) {
                    Element element7 = this.join(element5, element6, element4, n2, n3);
                    vector.addElement(element7);
                } else {
                    if (element6 != null) {
                        vector.addElement(this.cloneAsNecessary(element5, element6, n2, n3));
                    }
                    if (element4 != null) {
                        vector.addElement(this.cloneAsNecessary(element5, element4, n2, n3));
                    }
                }
                int n7 = element3.getElementCount();
                int n8 = n4 = element4 == null ? n6 : n6 + 1;
                while (n4 < n7) {
                    vector.addElement(this.clone(element5, element3.getElement(n4)));
                    ++n4;
                }
                Object[] objectArray = new Element[vector.size()];
                vector.copyInto(objectArray);
                ((AbstractDocument.BranchElement)element5).replace(0, 0, (Element[])objectArray);
                return element5;
            }
            throw new StateInvariantError("No support to join leaf element with non-leaf element");
        }

        class ElemChanges {
            Element parent;
            int index;
            Vector added;
            Vector removed;
            boolean isFracture;
            private final ElementBuffer this$1;

            public String toString() {
                return "added: " + this.added + "\nremoved: " + this.removed + "\n";
            }

            ElemChanges(ElementBuffer elementBuffer, Element element, int n2, boolean bl2) {
                this.this$1 = elementBuffer;
                this.parent = element;
                this.index = n2;
                this.isFracture = bl2;
                this.added = new Vector();
                this.removed = new Vector();
            }
        }
    }

    public static class ElementSpec {
        public static final short StartTagType = 1;
        public static final short EndTagType = 2;
        public static final short ContentType = 3;
        public static final short JoinPreviousDirection = 4;
        public static final short JoinNextDirection = 5;
        public static final short OriginateDirection = 6;
        public static final short JoinFractureDirection = 7;
        private AttributeSet attr;
        private int len;
        private short type;
        private short direction;
        private int offs;
        private char[] data;

        public int getLength() {
            return this.len;
        }

        public int getOffset() {
            return this.offs;
        }

        public short getDirection() {
            return this.direction;
        }

        public short getType() {
            return this.type;
        }

        public char[] getArray() {
            return this.data;
        }

        public void setDirection(short s2) {
            this.direction = s2;
        }

        public void setType(short s2) {
            this.type = s2;
        }

        public String toString() {
            String string = "??";
            String string2 = "??";
            switch (this.type) {
                case 1: {
                    string = "StartTag";
                    break;
                }
                case 3: {
                    string = "Content";
                    break;
                }
                case 2: {
                    string = "EndTag";
                }
            }
            switch (this.direction) {
                case 4: {
                    string2 = "JoinPrevious";
                    break;
                }
                case 5: {
                    string2 = "JoinNext";
                    break;
                }
                case 6: {
                    string2 = "Originate";
                    break;
                }
                case 7: {
                    string2 = "Fracture";
                }
            }
            return string + ":" + string2 + ":" + this.getLength();
        }

        public AttributeSet getAttributes() {
            return this.attr;
        }

        public ElementSpec(AttributeSet attributeSet, short s2) {
            this(attributeSet, s2, null, 0, 0);
        }

        public ElementSpec(AttributeSet attributeSet, short s2, int n2) {
            this(attributeSet, s2, null, 0, n2);
        }

        public ElementSpec(AttributeSet attributeSet, short s2, char[] cArray, int n2, int n3) {
            this.attr = attributeSet;
            this.type = s2;
            this.data = cArray;
            this.offs = n2;
            this.len = n3;
            this.direction = (short)6;
        }
    }

    protected class SectionElement
    extends AbstractDocument.BranchElement {
        private final DefaultStyledDocument this$0;

        public String getName() {
            return "section";
        }

        public SectionElement(DefaultStyledDocument defaultStyledDocument) {
            this.this$0 = defaultStyledDocument;
            super(defaultStyledDocument, null, null);
        }
    }

    class StyleChangeHandler
    implements ChangeListener {
        private final DefaultStyledDocument this$0;

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (object instanceof Style) {
                this.this$0.styleChanged((Style)object);
            } else {
                this.this$0.styleChanged(null);
            }
        }

        StyleChangeHandler(DefaultStyledDocument defaultStyledDocument) {
            this.this$0 = defaultStyledDocument;
        }
    }

    static class StyleChangeUndoableEdit
    extends AbstractUndoableEdit {
        protected AbstractDocument.AbstractElement element;
        protected Style newStyle;
        protected AttributeSet oldStyle;

        public void redo() throws CannotRedoException {
            super.redo();
            this.element.setResolveParent(this.newStyle);
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.element.setResolveParent(this.oldStyle);
        }

        public StyleChangeUndoableEdit(AbstractDocument.AbstractElement abstractElement, Style style) {
            this.element = abstractElement;
            this.newStyle = style;
            this.oldStyle = abstractElement.getResolveParent();
        }
    }

    class StyleContextChangeHandler
    implements ChangeListener {
        private final DefaultStyledDocument this$0;

        public void stateChanged(ChangeEvent changeEvent) {
            this.this$0.updateStylesListeningTo();
        }

        StyleContextChangeHandler(DefaultStyledDocument defaultStyledDocument) {
            this.this$0 = defaultStyledDocument;
        }
    }
}

