/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;

public class RepaintArea {
    private static final int MAX_BENEFIT_RATIO = 4;
    private static final int HORIZONTAL = 0;
    private static final int VERTICAL = 1;
    private static final int UPDATE = 2;
    private Rectangle[] paintRects = new Rectangle[3];

    public RepaintArea() {
    }

    public boolean isEmpty() {
        for (int i2 = 0; i2 < this.paintRects.length; ++i2) {
            if (this.paintRects[i2] == null) continue;
            return false;
        }
        return true;
    }

    public synchronized void add(Rectangle rectangle, int n2) {
        if (rectangle.isEmpty()) {
            return;
        }
        int n3 = 2;
        if (n2 == 800) {
            int n4 = n3 = rectangle.width > rectangle.height ? 0 : 1;
        }
        if (this.paintRects[n3] != null) {
            this.paintRects[n3].add(rectangle);
        } else {
            this.paintRects[n3] = new Rectangle(rectangle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Object object, boolean bl2) {
        Component component = (Component)object;
        if (this.isEmpty()) {
            return;
        }
        if (!component.isVisible()) {
            return;
        }
        RepaintArea repaintArea = this.cloneAndReset();
        if (!RepaintArea.subtract(repaintArea.paintRects[1], repaintArea.paintRects[0])) {
            RepaintArea.subtract(repaintArea.paintRects[0], repaintArea.paintRects[1]);
        }
        if (repaintArea.paintRects[0] != null && repaintArea.paintRects[1] != null) {
            Rectangle rectangle = repaintArea.paintRects[0].union(repaintArea.paintRects[1]);
            int n2 = rectangle.width * rectangle.height;
            int n3 = n2 - repaintArea.paintRects[0].width * repaintArea.paintRects[0].height - repaintArea.paintRects[1].width * repaintArea.paintRects[1].height;
            if (4 * n3 < n2) {
                repaintArea.paintRects[0] = rectangle;
                repaintArea.paintRects[1] = null;
            }
        }
        for (int i2 = 0; i2 < this.paintRects.length; ++i2) {
            Graphics graphics;
            if (repaintArea.paintRects[i2] == null || repaintArea.paintRects[i2].isEmpty() || (graphics = component.getGraphics()) == null) continue;
            try {
                graphics.setClip(repaintArea.paintRects[i2]);
                if (i2 == 2) {
                    component.update(graphics);
                    continue;
                }
                if (bl2) {
                    graphics.clearRect(repaintArea.paintRects[i2].x, repaintArea.paintRects[i2].y, repaintArea.paintRects[i2].width, repaintArea.paintRects[i2].height);
                }
                component.paint(graphics);
                continue;
            }
            finally {
                graphics.dispose();
            }
        }
    }

    private synchronized RepaintArea cloneAndReset() {
        RepaintArea repaintArea = new RepaintArea(this);
        for (int i2 = 0; i2 < this.paintRects.length; ++i2) {
            this.paintRects[i2] = null;
        }
        return repaintArea;
    }

    private RepaintArea(RepaintArea repaintArea) {
        for (int i2 = 0; i2 < this.paintRects.length; ++i2) {
            this.paintRects[i2] = repaintArea.paintRects[i2];
        }
    }

    static boolean subtract(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null || rectangle2 == null) {
            return true;
        }
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        if (rectangle3.isEmpty()) {
            return true;
        }
        if (rectangle.x == rectangle3.x && rectangle.y == rectangle3.y) {
            if (rectangle.width == rectangle3.width) {
                rectangle.y += rectangle3.height;
                rectangle.height -= rectangle3.height;
                return true;
            }
            if (rectangle.height == rectangle3.height) {
                rectangle.x += rectangle3.width;
                rectangle.width -= rectangle3.width;
                return true;
            }
        } else if (rectangle.x + rectangle.width == rectangle3.x + rectangle3.width && rectangle.y + rectangle.height == rectangle3.y + rectangle3.height) {
            if (rectangle.width == rectangle3.width) {
                rectangle.height -= rectangle3.height;
                return true;
            }
            if (rectangle.height == rectangle3.height) {
                rectangle.width -= rectangle3.width;
                return true;
            }
        }
        return false;
    }
}

