/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;

public class ByteArrayInputStream
extends InputStream {
    protected byte[] buf;
    protected int pos;
    protected int mark = 0;
    protected int count;

    public synchronized int available() {
        return this.count - this.pos;
    }

    public synchronized int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    public void close() throws IOException {
    }

    public synchronized void reset() {
        this.pos = this.mark;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n2) {
        this.mark = this.pos;
    }

    public synchronized long skip(long l2) {
        if ((long)this.pos + l2 > (long)this.count) {
            l2 = this.count - this.pos;
        }
        if (l2 < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + l2);
        return l2;
    }

    public ByteArrayInputStream(byte[] byArray) {
        this.buf = byArray;
        this.pos = 0;
        this.count = byArray.length;
    }

    public synchronized int read(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + n3 > this.count) {
            n3 = this.count - this.pos;
        }
        if (n3 <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, byArray, n2, n3);
        this.pos += n3;
        return n3;
    }

    public ByteArrayInputStream(byte[] byArray, int n2, int n3) {
        this.buf = byArray;
        this.pos = n2;
        this.count = Math.min(n2 + n3, byArray.length);
        this.mark = n2;
    }
}

