/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.peer.MenuPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

public class Menu
extends MenuItem
implements MenuContainer,
Accessible {
    Vector items = new Vector();
    boolean tearOff;
    boolean isHelpMenu;
    private static final String base = "menu";
    private static int nameCounter;
    private static final long serialVersionUID = -8809584163345499784L;
    private int menuSerializedDataVersion = 1;

    public int countItems() {
        return this.countItemsImpl();
    }

    final int countItemsImpl() {
        return this.items.size();
    }

    public int getItemCount() {
        return this.countItems();
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Menu.initIDs();
        }
        nameCounter = 0;
    }

    public Menu() throws HeadlessException {
        this("", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = Toolkit.getDefaultToolkit().createMenu(this);
            }
            int n2 = this.getItemCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                MenuItem menuItem = this.getItem(i2);
                menuItem.parent = this;
                menuItem.addNotify();
            }
        }
    }

    public void addSeparator() {
        this.add("-");
    }

    private static native void initIDs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n2 = this.getItemCount();
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                this.remove(i2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n2 = this.getItemCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.getItem(i2).removeNotify();
            }
            super.removeNotify();
        }
    }

    public boolean isTearOff() {
        return this.tearOff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertSeparator(int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n3;
            if (n2 < 0) {
                throw new IllegalArgumentException("index less than zero.");
            }
            int n4 = this.getItemCount();
            Vector vector = new Vector();
            for (n3 = n2; n3 < n4; ++n3) {
                vector.addElement(this.getItem(n2));
                this.remove(n2);
            }
            this.addSeparator();
            for (n3 = 0; n3 < vector.size(); ++n3) {
                this.add((MenuItem)vector.elementAt(n3));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            MenuItem menuItem = this.getItem(n2);
            this.items.removeElementAt(n2);
            MenuPeer menuPeer = (MenuPeer)this.peer;
            if (menuPeer != null) {
                menuItem.removeNotify();
                menuItem.parent = null;
                menuPeer.delItem(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(MenuComponent menuComponent) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n2 = this.items.indexOf(menuComponent);
            if (n2 >= 0) {
                this.remove(n2);
            }
        }
    }

    public MenuItem getItem(int n2) {
        return this.getItemImpl(n2);
    }

    final MenuItem getItemImpl(int n2) {
        return (MenuItem)this.items.elementAt(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(MenuItem menuItem, int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n3;
            if (n2 < 0) {
                throw new IllegalArgumentException("index less than zero.");
            }
            int n4 = this.getItemCount();
            Vector vector = new Vector();
            for (n3 = n2; n3 < n4; ++n3) {
                vector.addElement(this.getItem(n2));
                this.remove(n2);
            }
            this.add(menuItem);
            for (n3 = 0; n3 < vector.size(); ++n3) {
                this.add((MenuItem)vector.elementAt(n3));
            }
        }
    }

    void deleteShortcut(MenuShortcut menuShortcut) {
        int n2 = this.getItemCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.getItem(i2).deleteShortcut(menuShortcut);
        }
    }

    boolean handleShortcut(KeyEvent keyEvent) {
        int n2 = this.getItemCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            MenuItem menuItem = this.getItem(i2);
            if (!menuItem.handleShortcut(keyEvent)) continue;
            return true;
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, HeadlessException {
        objectInputStream.defaultReadObject();
        for (int i2 = 0; i2 < this.items.size(); ++i2) {
            MenuItem menuItem = (MenuItem)this.items.elementAt(i2);
            menuItem.parent = this;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            return base + nameCounter++;
        }
    }

    public String paramString() {
        String string = ",tearOff=" + this.tearOff + ",isHelpMenu=" + this.isHelpMenu;
        return super.paramString() + string;
    }

    public Menu(String string) throws HeadlessException {
        this(string, false);
    }

    public void add(String string) {
        this.add(new MenuItem(string));
    }

    public void insert(String string, int n2) {
        this.insert(new MenuItem(string), n2);
    }

    public Menu(String string, boolean bl2) throws HeadlessException {
        super(string);
        this.tearOff = bl2;
    }

    synchronized Enumeration shortcuts() {
        Vector vector = new Vector();
        int n2 = this.getItemCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            MenuItem menuItem = this.getItem(i2);
            if (menuItem instanceof Menu) {
                object = ((Menu)menuItem).shortcuts();
                while (object.hasMoreElements()) {
                    vector.addElement(object.nextElement());
                }
                continue;
            }
            object = menuItem.getShortcut();
            if (object == null) continue;
            vector.addElement(object);
        }
        return vector.elements();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTMenu(this);
        }
        return this.accessibleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuItem add(MenuItem menuItem) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (menuItem.parent != null) {
                menuItem.parent.remove(menuItem);
            }
            this.items.addElement(menuItem);
            menuItem.parent = this;
            MenuPeer menuPeer = (MenuPeer)this.peer;
            if (menuPeer != null) {
                menuItem.addNotify();
                menuPeer.addItem(menuItem);
            }
            return menuItem;
        }
    }

    MenuItem getShortcutMenuItem(MenuShortcut menuShortcut) {
        int n2 = this.getItemCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            MenuItem menuItem = this.getItem(i2).getShortcutMenuItem(menuShortcut);
            if (menuItem == null) continue;
            return menuItem;
        }
        return null;
    }

    protected class AccessibleAWTMenu
    extends MenuItem.AccessibleAWTMenuItem {
        private final Menu this$0;

        protected AccessibleAWTMenu(Menu menu) {
            this.this$0 = menu;
            super(menu);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }
    }
}

