/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import sun.awt.image.GifFrame;
import sun.awt.image.ImageDecoder;
import sun.awt.image.ImageFetcher;
import sun.awt.image.ImageFormatException;
import sun.awt.image.InputStreamImageSource;
import sun.awt.image.NativeLibLoader;
import sun.awt.image.PixelStore8;

public class GifImageDecoder
extends ImageDecoder {
    private static final boolean verbose = false;
    private static final int IMAGESEP = 44;
    private static final int EXBLOCK = 33;
    private static final int EX_GRAPHICS_CONTROL = 249;
    private static final int EX_COMMENT = 254;
    private static final int EX_APPLICATION = 255;
    private static final int TERMINATOR = 59;
    private static final int TRANSPARENCYMASK = 1;
    private static final int INTERLACEMASK = 64;
    private static final int COLORMAPMASK = 128;
    PixelStore8 store;
    boolean cancatchup = true;
    int num_global_colors;
    byte[] global_colormap;
    int trans_pixel = -1;
    IndexColorModel global_model;
    Hashtable props = new Hashtable();
    byte[] saved_image;
    IndexColorModel saved_model;
    int global_width;
    int global_height;
    int global_bgpixel;
    GifFrame curframe;
    private static final int normalflags = 30;
    private static final int interlaceflags = 29;
    private short[] prefix = new short[4096];
    private byte[] suffix = new byte[4096];
    private byte[] outCode = new byte[4097];

    static {
        NativeLibLoader.loadLibraries();
        GifImageDecoder.initIDs();
    }

    private static native void initIDs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void produceImage() throws IOException, ImageFormatException {
        try {
            this.readHeader();
            var1_1 = 0;
            var2_2 = 0;
            var3_3 = -1;
            var4_4 = 0;
            var5_5 = -1;
            var6_6 = false;
            var7_7 = false;
            block24: while (!this.aborted) {
                var8_8 = this.input.read();
                switch (var8_8) {
                    case 33: {
                        var8_8 = this.input.read();
                        switch (var8_8) {
                            case 249: {
                                var9_9 = new byte[6];
                                if (this.readBytes(var9_9, 0, 6) != 0) {
                                    return;
                                }
                                if (var9_9[0] != 4 || var9_9[5] != 0) {
                                    return;
                                }
                                var5_5 = GifImageDecoder.ExtractWord(var9_9, 2) * 10;
                                if (var5_5 > 0 && !var7_7) {
                                    var7_7 = true;
                                    this.cancatchup = false;
                                    this.store = null;
                                    ImageFetcher.startingAnimation();
                                }
                                var4_4 = var9_9[1] >> 2 & 7;
                                if ((var9_9[1] & 1) != 0) {
                                    this.trans_pixel = GifImageDecoder.ExtractByte(var9_9, 4);
                                    continue block24;
                                }
                                this.trans_pixel = -1;
                                continue block24;
                            }
                            default: {
                                var9_10 = false;
                                var10_13 = "";
                                while ((var11_14 = this.input.read()) > 0) {
                                    var12_15 = new byte[var11_14];
                                    if (this.readBytes(var12_15, 0, var11_14) != 0) {
                                        return;
                                    }
                                    if (var8_8 == 254) {
                                        var10_13 = var10_13 + new String(var12_15, 0);
                                        continue;
                                    }
                                    if (var8_8 != 255) continue;
                                    if (var9_10) {
                                        if (var11_14 == 3 && var12_15[0] == 1) {
                                            if (var6_6) {
                                                GifImageDecoder.ExtractWord(var12_15, 1);
                                            } else {
                                                var3_3 = GifImageDecoder.ExtractWord(var12_15, 1);
                                                var6_6 = true;
                                            }
                                        } else {
                                            var9_10 = false;
                                        }
                                    }
                                    if (!"NETSCAPE2.0".equals(new String(var12_15, 0))) continue;
                                    var9_10 = true;
                                }
                                if (var8_8 == 254) {
                                    this.props.put("comment", var10_13);
                                }
                                if (!var9_10 || var7_7) continue block24;
                                var7_7 = true;
                                this.cancatchup = false;
                                this.store = null;
                                ImageFetcher.startingAnimation();
                                continue block24;
                            }
                            ** case -1:
lbl68:
                            // 1 sources

                            break;
                        }
                        return;
                    }
                    case 44: {
                        if (!var7_7) {
                            this.input.mark(0);
                        }
                        try {
                            if (!this.readImage(var1_1 == 0, var4_4, var5_5)) {
                                this.cancatchup = false;
                                return;
                            }
                        }
                        catch (Exception var9_11) {
                            return;
                        }
                        ++var2_2;
                        ++var1_1;
                        continue block24;
                    }
                    default: {
                        if (var2_2 != 0) break;
                        return;
                    }
                    case 59: 
                }
                if (var3_3 == 0 || var3_3-- >= 0) {
                    try {
                        if (this.curframe != null) {
                            this.curframe.dispose();
                            this.curframe = null;
                        }
                        this.input.reset();
                        this.saved_image = null;
                        this.saved_model = null;
                        var2_2 = 0;
                        continue;
                    }
                    catch (IOException var9_12) {
                        this.close();
                        return;
                    }
                }
                if (this.store != null) {
                    this.store.imageComplete();
                    if (this.store.getBitState() != 2) {
                        this.source.setPixelStore(this, this.store);
                    }
                }
                this.imageComplete(3, true);
                return;
            }
        }
        finally {
            this.close();
        }
    }

    private void readHeader() throws IOException, ImageFormatException {
        byte[] byArray = new byte[13];
        if (this.readBytes(byArray, 0, 13) != 0) {
            throw new IOException();
        }
        if (byArray[0] != 71 || byArray[1] != 73 || byArray[2] != 70) {
            GifImageDecoder.error("not a GIF file.");
        }
        this.global_width = GifImageDecoder.ExtractWord(byArray, 6);
        this.global_height = GifImageDecoder.ExtractWord(byArray, 8);
        int n2 = GifImageDecoder.ExtractByte(byArray, 10);
        if ((n2 & 0x80) == 0) {
            this.num_global_colors = 2;
            this.global_bgpixel = 0;
            this.global_colormap = new byte[6];
            this.global_colormap[2] = 0;
            this.global_colormap[1] = 0;
            this.global_colormap[0] = 0;
            this.global_colormap[5] = -1;
            this.global_colormap[4] = -1;
            this.global_colormap[3] = -1;
        } else {
            this.num_global_colors = 1 << (n2 & 7) + 1;
            this.global_bgpixel = GifImageDecoder.ExtractByte(byArray, 11);
            if (byArray[12] != 0) {
                this.props.put("aspectratio", "" + (double)(GifImageDecoder.ExtractByte(byArray, 12) + 15) / 64.0);
            }
            this.global_colormap = new byte[this.num_global_colors * 3];
            if (this.readBytes(this.global_colormap, 0, this.num_global_colors * 3) != 0) {
                throw new IOException();
            }
        }
        this.input.mark(Integer.MAX_VALUE);
    }

    public synchronized void makeStore(int n2, int n3) {
        if (this.cancatchup) {
            this.store = new PixelStore8(n2, n3);
        }
    }

    private boolean readImage(boolean bl2, int n2, int n3) throws IOException {
        int n4;
        byte[] byArray;
        int n5;
        if (this.curframe != null && !this.curframe.dispose()) {
            this.abort();
            this.store = null;
            return false;
        }
        long l2 = 0L;
        byte[] byArray2 = new byte[259];
        if (this.readBytes(byArray2, 0, 10) != 0) {
            throw new IOException();
        }
        int n6 = GifImageDecoder.ExtractWord(byArray2, 0);
        int n7 = GifImageDecoder.ExtractWord(byArray2, 2);
        int n8 = GifImageDecoder.ExtractWord(byArray2, 4);
        int n9 = GifImageDecoder.ExtractWord(byArray2, 6);
        if (n8 == 0 && this.global_width != 0) {
            n8 = this.global_width - n6;
        }
        if (n9 == 0 && this.global_height != 0) {
            n9 = this.global_height - n7;
        }
        boolean bl3 = (byArray2[8] & 0x40) != 0;
        IndexColorModel indexColorModel = this.global_model;
        if ((byArray2[8] & 0x80) != 0) {
            n5 = 1 << (byArray2[8] & 7) + 1;
            byArray = new byte[n5 * 3];
            byArray[0] = byArray2[9];
            if (this.readBytes(byArray, 1, n5 * 3 - 1) != 0) {
                throw new IOException();
            }
            if (this.readBytes(byArray2, 9, 1) != 0) {
                throw new IOException();
            }
            if (this.trans_pixel >= n5) {
                n5 = this.trans_pixel + 1;
                byArray = GifImageDecoder.grow_colormap(byArray, n5);
            }
            indexColorModel = new IndexColorModel(8, n5, byArray, 0, false, this.trans_pixel);
        } else if (indexColorModel == null || this.trans_pixel != indexColorModel.getTransparentPixel()) {
            if (this.trans_pixel >= this.num_global_colors) {
                this.num_global_colors = this.trans_pixel + 1;
                this.global_colormap = GifImageDecoder.grow_colormap(this.global_colormap, this.num_global_colors);
            }
            this.global_model = indexColorModel = new IndexColorModel(8, this.num_global_colors, this.global_colormap, 0, false, this.trans_pixel);
        }
        if (bl2) {
            if (this.global_width == 0) {
                this.global_width = n8;
            }
            if (this.global_height == 0) {
                this.global_height = n9;
            }
            this.makeStore(this.global_width, this.global_height);
            if (this.store != null) {
                this.store.setProperties(this.props);
                this.store.setColorModel(indexColorModel);
            }
            this.setDimensions(this.global_width, this.global_height);
            this.setProperties(this.props);
            this.setColorModel(indexColorModel);
            this.headerComplete();
        } else if (this.store != null && indexColorModel != this.store.getColorModel()) {
            this.cancatchup = false;
            this.store = null;
        }
        if (n2 == 1 && this.saved_image == null) {
            this.saved_image = new byte[this.global_width * this.global_height];
            if (n9 < this.global_height && indexColorModel != null && (n5 = (int)((byte)indexColorModel.getTransparentPixel())) >= 0) {
                byArray = new byte[this.global_width];
                for (n4 = 0; n4 < this.global_width; n4 += 1) {
                    byArray[n4] = n5;
                }
                this.setPixels(0, 0, this.global_width, n7, (ColorModel)indexColorModel, byArray, 0, 0);
                this.setPixels(0, n7 + n9, this.global_width, this.global_height - n9 - n7, (ColorModel)indexColorModel, byArray, 0, 0);
            }
        }
        n5 = bl3 ? 29 : 30;
        this.setHints(n5);
        if (this.store != null) {
            this.store.setHints(n5);
        }
        this.curframe = new GifFrame(this, n2, n3, this.curframe == null, indexColorModel, n6, n7, n8, n9);
        byArray = new byte[n8];
        n4 = this.parseImage(n6, n7, n8, n9, bl3, GifImageDecoder.ExtractByte(byArray2, 9), byArray2, byArray, indexColorModel) ? 1 : 0;
        if (!n4) {
            this.abort();
            this.store = null;
        }
        return n4 != 0;
    }

    private static final int ExtractByte(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF;
    }

    private static final int ExtractWord(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8;
    }

    public static byte[] grow_colormap(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[n2 * 3];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    private int readBytes(byte[] byArray, int n2, int n3) {
        while (n3 > 0) {
            try {
                int n4 = this.input.read(byArray, n2, n3);
                if (n4 < 0) break;
                n2 += n4;
                n3 -= n4;
            }
            catch (IOException iOException) {
                break;
            }
        }
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int sendPixels(int n2, int n3, int n4, int n5, byte[] byArray, ColorModel colorModel) {
        int n6;
        int n7;
        boolean bl2;
        int n8;
        int n9;
        block15: {
            int n10;
            int n11;
            int n12;
            block16: {
                block14: {
                    block12: {
                        block13: {
                            if (n3 < 0) {
                                n5 += n3;
                                n3 = 0;
                            }
                            if (n3 + n5 > this.global_height) {
                                n5 = this.global_height - n3;
                            }
                            if (n5 <= 0) {
                                return 1;
                            }
                            if (n2 < 0) {
                                n12 = -n2;
                                n4 += n2;
                                n11 = 0;
                            } else {
                                n12 = 0;
                                n11 = n2;
                            }
                            if (n11 + n4 > this.global_width) {
                                n4 = this.global_width - n11;
                            }
                            if (n4 <= 0) {
                                return 1;
                            }
                            n9 = n12 + n4;
                            n8 = n3 * this.global_width + n11;
                            boolean bl3 = bl2 = this.curframe.disposal_method == 1;
                            if (this.trans_pixel < 0 || this.curframe.initialframe) break block12;
                            if (this.saved_image == null || this.saved_model != colorModel) break block13;
                            break block14;
                        }
                        n7 = -1;
                        n6 = 1;
                        break block15;
                    }
                    if (!bl2) break block16;
                    System.arraycopy(byArray, n12, this.saved_image, n8, n4);
                    break block16;
                }
                for (n10 = n12; n10 < n9; ++n10, ++n8) {
                    byte by = byArray[n10];
                    if ((by & 0xFF) == this.trans_pixel) {
                        byArray[n10] = this.saved_image[n8];
                        continue;
                    }
                    if (!bl2) continue;
                    this.saved_image[n8] = by;
                }
            }
            n10 = this.setPixels(n11, n3, n4, n5, colorModel, byArray, n12, 0);
            if (this.store == null) return n10;
            if (this.store.setPixels(n11, n3, n4, n5, byArray, n12, 0)) return n10;
            this.store = null;
            return n10;
        }
        for (int i2 = n12; i2 < n9; ++i2, ++n8) {
            byte by = byArray[i2];
            if ((by & 0xFF) == this.trans_pixel) {
                if (n7 >= 0 && (n6 = this.setPixels(n2 + n7, n3, i2 - n7, n5, colorModel, byArray, n7, 0)) == 0) break;
                n7 = -1;
                continue;
            }
            if (n7 < 0) {
                n7 = i2;
            }
            if (!bl2) continue;
            this.saved_image[n8] = by;
        }
        if (n7 < 0) return n6;
        return this.setPixels(n2 + n7, n3, n9 - n7, n5, colorModel, byArray, n7, 0);
    }

    public void replayConsumer(ImageConsumer imageConsumer) {
        if (this.store != null) {
            this.store.replay(this.source, imageConsumer, false);
        }
    }

    private native boolean parseImage(int var1, int var2, int var3, int var4, boolean var5, int var6, byte[] var7, byte[] var8, IndexColorModel var9);

    private static void error(String string) throws ImageFormatException {
        throw new ImageFormatException(string);
    }

    public synchronized boolean catchupConsumer(InputStreamImageSource inputStreamImageSource, ImageConsumer imageConsumer) {
        return this.cancatchup && (this.store == null || this.store.replay(inputStreamImageSource, imageConsumer));
    }

    public GifImageDecoder(InputStreamImageSource inputStreamImageSource, InputStream inputStream) {
        super(inputStreamImageSource, inputStream);
    }
}

